/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.events;

import io.a2a.server.events.EventQueue;
import io.a2a.server.events.NoTaskQueueException;
import io.a2a.server.events.QueueManager;
import io.a2a.server.events.TaskQueueExistsException;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@ApplicationScoped
public class InMemoryQueueManager
implements QueueManager {
    private final ConcurrentMap<String, EventQueue> queues = new ConcurrentHashMap<String, EventQueue>();

    @Override
    public void add(String taskId, EventQueue queue) {
        EventQueue existing = this.queues.putIfAbsent(taskId, queue);
        if (existing != null) {
            throw new TaskQueueExistsException();
        }
    }

    @Override
    public EventQueue get(String taskId) {
        return (EventQueue)this.queues.get(taskId);
    }

    @Override
    public EventQueue tap(String taskId) {
        EventQueue queue = (EventQueue)this.queues.get(taskId);
        return queue == null ? null : queue.tap();
    }

    @Override
    public void close(String taskId) {
        EventQueue existing = (EventQueue)this.queues.remove(taskId);
        if (existing == null) {
            throw new NoTaskQueueException();
        }
    }

    @Override
    public EventQueue createOrTap(String taskId) {
        EventQueue existing = (EventQueue)this.queues.get(taskId);
        EventQueue newQueue = null;
        if (existing == null) {
            newQueue = EventQueue.create();
            existing = this.queues.putIfAbsent(taskId, newQueue);
        }
        return existing == null ? newQueue : existing.tap();
    }

    @Override
    public void awaitQueuePollerStart(EventQueue eventQueue) throws InterruptedException {
        eventQueue.awaitQueuePollerStart();
    }
}

