/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.tasks;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.a2a.client.http.A2AHttpClient;
import io.a2a.client.http.JdkA2AHttpClient;
import io.a2a.server.tasks.PushNotificationConfigStore;
import io.a2a.server.tasks.PushNotificationSender;
import io.a2a.spec.PushNotificationConfig;
import io.a2a.spec.Task;
import io.a2a.util.Utils;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class BasePushNotificationSender
implements PushNotificationSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePushNotificationSender.class);
    private final A2AHttpClient httpClient;
    private final PushNotificationConfigStore configStore;

    @Inject
    public BasePushNotificationSender(PushNotificationConfigStore configStore) {
        this.httpClient = new JdkA2AHttpClient();
        this.configStore = configStore;
    }

    public BasePushNotificationSender(PushNotificationConfigStore configStore, A2AHttpClient httpClient) {
        this.configStore = configStore;
        this.httpClient = httpClient;
    }

    @Override
    public void sendNotification(Task task) {
        List<PushNotificationConfig> pushConfigs = this.configStore.getInfo(task.getId());
        if (pushConfigs == null || pushConfigs.isEmpty()) {
            return;
        }
        List<CompletableFuture> dispatchResults = pushConfigs.stream().map(pushConfig -> this.dispatch(task, (PushNotificationConfig)pushConfig)).toList();
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(dispatchResults.toArray(new CompletableFuture[0]));
        CompletionStage dispatchResult = allFutures.thenApply(v -> dispatchResults.stream().allMatch(CompletableFuture::join));
        try {
            boolean allSent = (Boolean)((CompletableFuture)dispatchResult).get();
            if (!allSent) {
                LOGGER.warn("Some push notifications failed to send for taskId: " + task.getId());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.warn("Some push notifications failed to send for taskId " + task.getId() + ": {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private CompletableFuture<Boolean> dispatch(Task task, PushNotificationConfig pushInfo) {
        return CompletableFuture.supplyAsync(() -> this.dispatchNotification(task, pushInfo));
    }

    private boolean dispatchNotification(Task task, PushNotificationConfig pushInfo) {
        String body;
        String url = pushInfo.url();
        try {
            body = Utils.OBJECT_MAPPER.writeValueAsString((Object)task);
        }
        catch (JsonProcessingException e) {
            LOGGER.debug("Error writing value as string: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        catch (Throwable throwable) {
            LOGGER.debug("Error writing value as string: {}", (Object)throwable.getMessage(), (Object)throwable);
            return false;
        }
        try {
            ((A2AHttpClient.PostBuilder)this.httpClient.createPost().url(url)).body(body).post();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.debug("Error pushing data to " + url + ": {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }
}

