/*
 * Decompiled with CFR 0.152.
 */
package io.github.acm19.aws.interceptor.http;

import io.github.acm19.aws.interceptor.http.RequestSigner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

public final class AwsRequestSigningApacheInterceptor
implements HttpRequestInterceptor {
    private final RequestSigner signer;

    public AwsRequestSigningApacheInterceptor(String service, Signer signer, AwsCredentialsProvider awsCredentialsProvider, Region region) {
        this.signer = new RequestSigner(service, signer, awsCredentialsProvider, region);
    }

    public AwsRequestSigningApacheInterceptor(String service, Signer signer, AwsCredentialsProvider awsCredentialsProvider, String region) {
        this(service, signer, awsCredentialsProvider, Region.of((String)region));
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpEntityEnclosingRequest httpEntityEnclosingRequest;
        HttpEntityEnclosingRequest httpEntityEnclosingRequest2;
        URI requestUri = RequestSigner.buildUri(context, request.getRequestLine().getUri());
        SdkHttpFullRequest.Builder requestBuilder = SdkHttpFullRequest.builder().method(SdkHttpMethod.fromValue((String)request.getRequestLine().getMethod())).uri(requestUri);
        if (request instanceof HttpEntityEnclosingRequest && (httpEntityEnclosingRequest2 = (HttpEntityEnclosingRequest)request).getEntity() != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            httpEntityEnclosingRequest2.getEntity().writeTo((OutputStream)outputStream);
            requestBuilder.contentStreamProvider(() -> new ByteArrayInputStream(outputStream.toByteArray()));
        }
        requestBuilder.headers(AwsRequestSigningApacheInterceptor.headerArrayToMap(request.getAllHeaders()));
        SdkHttpFullRequest signedRequest = this.signer.signRequest(requestBuilder.build());
        request.setHeaders(AwsRequestSigningApacheInterceptor.mapToHeaderArray(signedRequest.headers()));
        if (request instanceof HttpEntityEnclosingRequest && (httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)request).getEntity() != null) {
            BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
            basicHttpEntity.setContent(((ContentStreamProvider)signedRequest.contentStreamProvider().orElseThrow(() -> new IllegalStateException("There must be content"))).newStream());
            httpEntityEnclosingRequest.setEntity((HttpEntity)new BufferedHttpEntity((HttpEntity)basicHttpEntity));
        }
    }

    private static Map<String, List<String>> headerArrayToMap(Header[] headers) {
        TreeMap<String, List<String>> headersMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (Header header : headers) {
            if (AwsRequestSigningApacheInterceptor.skipHeader(header)) continue;
            headersMap.put(header.getName(), headersMap.getOrDefault(header.getName(), new LinkedList<String>(Collections.singletonList(header.getValue()))));
        }
        return headersMap;
    }

    private static boolean skipHeader(Header header) {
        return "Content-Length".equalsIgnoreCase(header.getName()) && "0".equals(header.getValue()) || "Host".equalsIgnoreCase(header.getName());
    }

    private static Header[] mapToHeaderArray(Map<String, List<String>> mapHeaders) {
        Header[] headers = new Header[mapHeaders.size()];
        int i = 0;
        for (Map.Entry<String, List<String>> headerEntry : mapHeaders.entrySet()) {
            for (String value : headerEntry.getValue()) {
                headers[i++] = new BasicHeader(headerEntry.getKey(), value);
            }
        }
        return headers;
    }
}

