/*
 * Decompiled with CFR 0.152.
 */
package io.github.acm19.aws.interceptor.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.protocol.HttpContext;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.regions.Region;

class RequestSigner {
    private final String service;
    private final Signer signer;
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final Region region;

    RequestSigner(String service, Signer signer, AwsCredentialsProvider awsCredentialsProvider, Region region) {
        this.service = service;
        this.signer = signer;
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.region = Objects.requireNonNull(region);
    }

    SdkHttpFullRequest signRequest(SdkHttpFullRequest request) {
        ExecutionAttributes attributes = new ExecutionAttributes();
        attributes.putAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS, (Object)this.awsCredentialsProvider.resolveCredentials());
        attributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, (Object)this.service);
        attributes.putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, (Object)this.region);
        return this.signer.sign(request, attributes);
    }

    static URI buildUri(HttpContext context, String uri) throws IOException {
        try {
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpHost host = (HttpHost)context.getAttribute("http.target_host");
            if (host != null) {
                uriBuilder.setHost(host.getHostName());
                uriBuilder.setScheme(host.getSchemeName());
                uriBuilder.setPort(host.getPort());
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            throw new IOException("Invalid URI", ex);
        }
    }
}

