/*
 * Decompiled with CFR 0.152.
 */
package io.github.acm19.aws.interceptor.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.protocol.HttpContext;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.regions.Region;

class RequestSigner {
    private final String service;
    private final HttpSigner<AwsCredentialsIdentity> signer;
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final Region region;

    RequestSigner(String service, HttpSigner<AwsCredentialsIdentity> signer, AwsCredentialsProvider awsCredentialsProvider, Region region) {
        this.service = service;
        this.signer = signer;
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.region = Objects.requireNonNull(region);
    }

    SignedRequest signRequest(SdkHttpFullRequest request) {
        SignedRequest signedRequest = this.signer.sign(r -> {
            SignRequest.Builder cfr_ignored_0 = (SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)r.identity((Identity)this.awsCredentialsProvider.resolveCredentials())).request((SdkHttpRequest)request)).payload(request.contentStreamProvider().orElse(null))).putProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)this.service)).putProperty(AwsV4HttpSigner.REGION_NAME, (Object)this.region.id());
        });
        return signedRequest;
    }

    static URI buildUri(HttpContext context, String uri) throws IOException {
        try {
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpHost host = (HttpHost)context.getAttribute("http.target_host");
            if (host != null) {
                uriBuilder.setHost(host.getHostName());
                uriBuilder.setScheme(host.getSchemeName());
                uriBuilder.setPort(host.getPort());
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            throw new IOException("Invalid URI", ex);
        }
    }
}

