/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca50.controller;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.MChart;
import org.compiere.model.MChartDatasource;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.spin.eca50.data.ChartDataValue;
import org.spin.eca50.data.ChartSeriesValue;
import org.spin.eca50.data.ChartValue;
import org.spin.eca50.util.ChartQueryDefinition;

public class ChartBuilder {
    private static ChartQueryDefinition getDataSourceQuery(int chartDatasourceId, boolean isTimeSeries, String timeUnit, int timeScope, Map<String, Object> customParameters) {
        Object category;
        if (chartDatasourceId <= 0) {
            throw new AdempiereException("@FillMandatory@ @AD_ChartDatasource_ID@");
        }
        MChartDatasource datasource = new MChartDatasource(Env.getCtx(), chartDatasourceId, null);
        if (datasource == null || datasource.getAD_ChartDatasource_ID() <= 0) {
            throw new AdempiereException("@AD_ChartDatasource_ID@ @NotFound@");
        }
        String value = datasource.getValueColumn();
        String dateColumn = datasource.getDateColumn();
        String seriesColumn = datasource.getSeriesColumn();
        String name = datasource.getName();
        String where = datasource.getWhereClause();
        String fromClause = datasource.getFromClause();
        String unit = "D";
        if (!isTimeSeries) {
            category = datasource.getCategoryColumn();
        } else {
            if (timeUnit.equals("W")) {
                unit = "W";
            } else if (timeUnit.equals("M")) {
                unit = "MM";
            } else if (timeUnit.equals("Q")) {
                unit = "Q";
            } else if (timeUnit.equals("Y")) {
                unit = "Y";
            }
            category = " TRUNC(" + dateColumn + ", '" + unit + "') ";
        }
        String series = DB.TO_STRING((String)name);
        boolean hasSeries = false;
        if (seriesColumn != null) {
            series = seriesColumn;
            hasSeries = true;
        }
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer("SELECT " + value + ", " + (String)category + ", " + series);
        sql.append(" FROM ").append(fromClause);
        StringBuffer whereClause = new StringBuffer(" WHERE 1=1 ");
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Timestamp startDate = null;
        Timestamp endDate = null;
        int scope = timeScope;
        int offset = datasource.getTimeOffset();
        if (isTimeSeries && scope != 0) {
            startDate = TimeUtil.getDay((Timestamp)TimeUtil.addDuration((Timestamp)currentDate, (String)timeUnit, (int)(offset += -scope)));
            endDate = TimeUtil.getDay((Timestamp)TimeUtil.addDuration((Timestamp)currentDate, (String)timeUnit, (int)scope));
        }
        if (startDate != null && endDate != null) {
            whereClause.append(" AND ").append((String)category).append(" >= ? ").append("AND ").append((String)category).append(" <= ? ");
            parameters.add(startDate);
            parameters.add(endDate);
        }
        if (customParameters != null && customParameters.size() > 0) {
            customParameters.entrySet().forEach(parameter -> {
                whereClause.append(" AND ").append((String)parameter.getKey());
                Object currentValue = parameter.getValue();
                if (currentValue instanceof Collection) {
                    ChartBuilder.addCollectionParameters(currentValue, parameters);
                } else {
                    parameters.add(currentValue);
                }
            });
        }
        sql.append(whereClause);
        MRole role = MRole.getDefault((Properties)Env.getCtx(), (boolean)false);
        Object sqlWithAccess = role.addAccessSQL(sql.toString(), null, true, false);
        if (!Util.isEmpty((String)where, (boolean)true)) {
            String parsedWhere = Env.parseContext((Properties)Env.getCtx(), (int)0, (String)where, (boolean)true);
            if (parsedWhere.trim().startsWith("WHERE")) {
                int startIndex = "WHERE".length();
                parsedWhere = parsedWhere.trim().substring(startIndex);
            }
            sqlWithAccess = (String)sqlWithAccess + " AND (" + parsedWhere.trim() + ")";
        }
        sql = new StringBuffer((String)sqlWithAccess);
        if (hasSeries) {
            sql.append(" GROUP BY " + series + ", " + (String)category + " ORDER BY " + series + ", " + (String)category);
        } else {
            sql.append(" GROUP BY " + (String)category + " ORDER BY " + (String)category);
        }
        return new ChartQueryDefinition(name, sql.toString(), parameters);
    }

    public static ChartValue getChartData(int chartId, Map<String, Object> customParameters) {
        if (chartId <= 0) {
            throw new AdempiereException("@AD_Chart_ID@ @NotFound@");
        }
        MChart chart = new MChart(Env.getCtx(), chartId, null);
        ChartValue metrics = new ChartValue(chart.getName());
        ArrayList dataSources = new ArrayList();
        new Query(Env.getCtx(), "AD_ChartDatasource", "AD_Chart_ID = ?", null).setParameters(new Object[]{chart.getAD_Chart_ID()}).setOnlyActiveRecords(true).getIDsAsList().forEach(chartDataSourceId -> {
            ChartQueryDefinition queryDefinition = ChartBuilder.getDataSourceQuery(chartDataSourceId, chart.isTimeSeries(), chart.getTimeUnit(), chart.getTimeScope(), customParameters);
            dataSources.add(queryDefinition);
        });
        if (dataSources != null && dataSources.size() > 0) {
            HashMap seriesMap = new HashMap();
            dataSources.forEach(dataSource -> {
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    pstmt = DB.prepareStatement((String)dataSource.getQuery(), null);
                    DB.setParameters((PreparedStatement)pstmt, dataSource.getParameters());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String key = rs.getString(2);
                        String seriesName = rs.getString(3);
                        if (chart.isTimeSeries()) {
                            // empty if block
                        }
                        BigDecimal amount = rs.getBigDecimal(1);
                        List<HashMap<String, BigDecimal>> valuesList = new ArrayList();
                        if (seriesMap.containsKey(seriesName)) {
                            valuesList = (List)seriesMap.get(seriesName);
                        }
                        HashMap<String, BigDecimal> valuesMap = new HashMap<String, BigDecimal>();
                        valuesMap.put(key, amount);
                        valuesList.add(valuesMap);
                        seriesMap.put(seriesName, valuesList);
                    }
                }
                catch (Exception e) {
                    try {
                        throw new AdempiereException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            });
            seriesMap.entrySet().stream().forEach(seriesEntry -> {
                ChartSeriesValue chartSerie = new ChartSeriesValue((String)seriesEntry.getKey());
                ((List)seriesEntry.getValue()).stream().forEach(serie -> serie.entrySet().stream().forEach(value -> {
                    String name = (String)value.getKey();
                    BigDecimal amount = (BigDecimal)value.getValue();
                    ChartDataValue data = new ChartDataValue(name, amount);
                    chartSerie.addData(data);
                }));
                metrics.addSerie(chartSerie);
            });
        }
        return metrics;
    }

    public static void addCollectionParameters(Object objectColelction, List<Object> parameters) {
        if (objectColelction instanceof Collection) {
            try {
                Collection collection = (Collection)objectColelction;
                for (Object rangeValue : collection) {
                    parameters.add(rangeValue);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public static void main(String[] args) {
        Adempiere.startup((boolean)true);
        Env.setContext((Properties)Env.getCtx(), (String)"#Date", (Timestamp)new Timestamp(System.currentTimeMillis()));
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)1000000);
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)1000000);
        HashMap<String, Object> customParameters = new HashMap<String, Object>();
        customParameters.put("i.DateInvoiced <= ?", new Timestamp(System.currentTimeMillis()));
        ChartValue data = ChartBuilder.getChartData(1000000, customParameters);
        System.out.println(data);
    }
}

