/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.model.validator;

import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.queue.util.QueueLoader;

public class EngineAsQueue
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EngineAsQueue.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        new Query(Env.getCtx(), "AD_Table", "IsDocument = 'Y'", null).setOnlyActiveRecords(true).list().forEach(table -> engine.addDocValidate(table.getTableName(), (ModelValidator)this));
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        if (type == 1 || type == 2) {
            if (entity.get_TableName().equals("AD_Process")) {
                if (entity.is_new() || !entity.is_ValueChanged("Statistic_Count") && !entity.is_ValueChanged("Statistic_Seconds")) {
                    QueueLoader.getInstance().getQueueManager("ADM").withEntity(entity);
                }
            } else if (entity.get_TableName().equals("AD_Form") || entity.get_TableName().equals("AD_Form_Trl")) {
                QueueLoader.getInstance().getQueueManager("ADM").withEntity(entity);
            }
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        if (timing == 9 || timing == 13 || timing == 14 || timing == 10) {
            QueueLoader.getInstance().getQueueManager("DMM").withEntity(entity).addToQueue();
        }
        return null;
    }
}

