/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.process;

import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.core.domains.models.I_AD_Browse;
import org.adempiere.core.domains.models.I_AD_Form;
import org.adempiere.core.domains.models.I_AD_Menu;
import org.adempiere.core.domains.models.I_AD_Process;
import org.adempiere.core.domains.models.I_AD_Window;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MBrowse;
import org.compiere.model.MForm;
import org.compiere.model.MMenu;
import org.compiere.model.MProcess;
import org.compiere.model.MWindow;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.eca56.process.ExportCurrentDictionaryDefinitionAbstract;
import org.spin.queue.util.QueueLoader;

public class ExportCurrentDictionaryDefinition
extends ExportCurrentDictionaryDefinitionAbstract {
    private AtomicInteger counter = new AtomicInteger();

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() <= 0) {
            throw new AdempiereException("@FillMandatory@ @Record_ID@");
        }
        if (this.getTable_ID() <= 0) {
            throw new AdempiereException("@FillMandatory@ @AD_Table@");
        }
    }

    protected String doIt() throws Exception {
        if (this.getTable_ID() == I_AD_Menu.Table_ID) {
            this.exportMenuDefinition();
        }
        if (this.getTable_ID() == I_AD_Window.Table_ID) {
            this.exportWindowDefinition();
        }
        if (this.getTable_ID() == I_AD_Process.Table_ID) {
            this.exportProcessDefinition();
        }
        if (this.getTable_ID() == I_AD_Browse.Table_ID) {
            this.exportBrowserDefinition();
        }
        if (this.getTable_ID() == I_AD_Form.Table_ID) {
            this.exportFormDefinition();
        }
        return "Ok";
    }

    private void exportMenuDefinition() {
        this.addLog("@AD_Menu_ID@");
        MMenu menuNode = (MMenu)new Query(this.getCtx(), "AD_Menu", "AD_Menu_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getRecord_ID()}).first();
        QueueLoader.getInstance().getQueueManager("ADM").withEntity((PO)menuNode).addToQueue();
        this.counter.incrementAndGet();
    }

    private void exportWindowDefinition() {
        this.addLog("@AD_Window_ID@");
        MWindow window = new MWindow(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        QueueLoader.getInstance().getQueueManager("ADM").withEntity((PO)window).addToQueue();
        this.addLog(window.getName());
        this.counter.incrementAndGet();
    }

    private void exportProcessDefinition() {
        this.addLog("@AD_Process_ID@");
        MProcess process = new MProcess(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        QueueLoader.getInstance().getQueueManager("ADM").withEntity((PO)process).addToQueue();
        this.addLog(process.getValue() + " - " + process.getName());
        this.counter.incrementAndGet();
    }

    private void exportBrowserDefinition() {
        this.addLog("@AD_Browse_ID@");
        MBrowse browser = new MBrowse(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        QueueLoader.getInstance().getQueueManager("ADM").withEntity((PO)browser).addToQueue();
        this.addLog(browser.getValue() + " - " + browser.getName());
        this.counter.incrementAndGet();
    }

    private void exportFormDefinition() {
        this.addLog("@AD_Form_ID@");
        MForm form = new MForm(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        QueueLoader.getInstance().getQueueManager("ADM").withEntity((PO)form).addToQueue();
        this.addLog(form.getClassname() + " - " + form.getName());
        this.counter.incrementAndGet();
    }
}

