/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.process;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.model.MBrowse;
import org.compiere.model.MClientInfo;
import org.compiere.model.MForm;
import org.compiere.model.MMenu;
import org.compiere.model.MProcess;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.MWindow;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.eca56.process.ExportDictionaryDefinitionAbstract;
import org.spin.queue.util.QueueLoader;

public class ExportDictionaryDefinition
extends ExportDictionaryDefinitionAbstract {
    private AtomicInteger counter = new AtomicInteger();

    protected String doIt() throws Exception {
        if (this.isExportMenu()) {
            this.exportMenuDefinition();
        }
        if (this.isExportWindows()) {
            this.exportWindowsDefinition();
        }
        if (this.isExportProcess()) {
            this.exportProcessesDefinition();
        }
        if (this.isExportBrowsers()) {
            this.exportBrowsersDefinition();
        }
        if (this.isExportForms()) {
            this.exportFormsDefinition();
        }
        return "@Created@ " + this.counter.get();
    }

    private void exportMenuDefinition() {
        if (this.getMenuId() > 0) {
            this.addLog("@AD_Menu_ID@");
            MMenu menuNode = (MMenu)new Query(this.getCtx(), "AD_Menu", "AD_Menu_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getMenuId()}).first();
            QueueLoader.getInstance().getQueueManager("ADM").withEntity((PO)menuNode).addToQueue();
            this.counter.incrementAndGet();
        } else {
            MClientInfo clientInfo = MClientInfo.get((Properties)this.getCtx(), (int)this.getAD_Client_ID());
            if (clientInfo.getAD_Tree_Menu_ID() > 0) {
                this.addLog("@AD_Menu_ID@");
                MTree tree = new MTree(this.getCtx(), clientInfo.getAD_Tree_Menu_ID(), false, false, null, null);
                MTreeNode rootNode = tree.getRoot();
                Enumeration childrens = rootNode.children();
                while (childrens.hasMoreElements()) {
                    MTreeNode childNode = (MTreeNode)childrens.nextElement();
                    QueueLoader.getInstance().getQueueManager("ADM").withEntity((PO)MMenu.getFromId((Properties)this.getCtx(), (int)childNode.getNode_ID())).addToQueue();
                    this.addLog(childNode.getNode_ID() + " - " + childNode.getName());
                    this.counter.incrementAndGet();
                }
            }
        }
    }

    private void exportWindowsDefinition() {
        this.addLog("@AD_Window_ID@");
        String whereClause = "";
        ArrayList<Integer> filtersList = new ArrayList<Integer>();
        if (this.getWindowId() > 0) {
            whereClause = "AD_Window_ID = ?";
            filtersList.add(this.getWindowId());
        }
        new Query(this.getCtx(), "AD_Window", whereClause, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(filtersList).getIDsAsList().forEach(windowId -> {
            MWindow window = new MWindow(this.getCtx(), windowId.intValue(), this.get_TrxName());
            QueueLoader.getInstance().getQueueManager("ADM").withEntity((PO)window).addToQueue();
            this.addLog(window.getAD_Window_ID() + " - " + window.getName());
            this.counter.incrementAndGet();
        });
    }

    private void exportProcessesDefinition() {
        this.addLog("@AD_Process_ID@");
        String whereClause = "";
        ArrayList<Integer> filtersList = new ArrayList<Integer>();
        if (this.getADProcessId() > 0) {
            whereClause = "AD_Process_ID = ?";
            filtersList.add(this.getADProcessId());
        }
        new Query(this.getCtx(), "AD_Process", whereClause, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(filtersList).getIDsAsList().forEach(processId -> {
            MProcess process = new MProcess(this.getCtx(), processId.intValue(), this.get_TrxName());
            QueueLoader.getInstance().getQueueManager("ADM").withEntity((PO)process).addToQueue();
            this.addLog(process.getValue() + " - " + process.getName());
            this.counter.incrementAndGet();
        });
    }

    private void exportBrowsersDefinition() {
        this.addLog("@AD_Browse_ID@");
        String whereClause = "";
        ArrayList<Integer> filtersList = new ArrayList<Integer>();
        if (this.getBrowseId() > 0) {
            whereClause = "AD_Browse_ID = ?";
            filtersList.add(this.getBrowseId());
        }
        new Query(this.getCtx(), "AD_Browse", whereClause, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(filtersList).getIDsAsList().forEach(browseId -> {
            MBrowse browser = new MBrowse(this.getCtx(), browseId.intValue(), this.get_TrxName());
            QueueLoader.getInstance().getQueueManager("ADM").withEntity((PO)browser).addToQueue();
            this.addLog(browser.getValue() + " - " + browser.getName());
            this.counter.incrementAndGet();
        });
    }

    private void exportFormsDefinition() {
        this.addLog("@AD_Form_ID@");
        String whereClause = "";
        ArrayList<Integer> filtersList = new ArrayList<Integer>();
        if (this.getFormId() > 0) {
            whereClause = "AD_Form_ID = ?";
            filtersList.add(this.getFormId());
        }
        new Query(this.getCtx(), "AD_Form", whereClause, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(filtersList).getIDsAsList().forEach(formId -> {
            MForm form = new MForm(this.getCtx(), formId.intValue(), this.get_TrxName());
            QueueLoader.getInstance().getQueueManager("ADM").withEntity((PO)form).addToQueue();
            this.addLog(form.getClassname() + " - " + form.getName());
            this.counter.incrementAndGet();
        });
    }
}

