/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.setup;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.spin.eca56.util.support.kafka.Sender;
import org.spin.model.MADAppRegistration;
import org.spin.model.MADAppSupport;
import org.spin.util.ISetupDefinition;

public class CreateConfig
implements ISetupDefinition {
    private static final String DESCRIPTION = "(*Created from Setup Automatically*)";
    private static final String APPLICATION_TYPE = "MQS";

    public String doIt(Properties context, String transactionName) {
        this.createDefaultSender(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void createDefaultSender(Properties context, String transactionName) {
        MADAppRegistration processSender = (MADAppRegistration)new Query(context, "AD_AppRegistration", "EXISTS(SELECT 1 FROM AD_AppSupport s WHERE s.AD_AppSupport_ID = AD_AppRegistration.AD_AppSupport_ID AND s.Classname = ?)", transactionName).setParameters(new Object[]{Sender.class.getName()}).setClient_ID().first();
        if (processSender == null || processSender.getAD_AppRegistration_ID() <= 0) {
            MADAppSupport queueSupport = (MADAppSupport)new Query(context, "AD_AppSupport", "Classname = ?", transactionName).setParameters(new Object[]{Sender.class.getName()}).first();
            if (queueSupport == null || queueSupport.getAD_AppSupport_ID() <= 0) {
                throw new AdempiereException("@AD_AppSupport_ID@ @NotFound@");
            }
            processSender = new MADAppRegistration(context, 0, transactionName);
            processSender.setValue("Engine-Queue");
            processSender.setApplicationType(APPLICATION_TYPE);
            processSender.setAD_AppSupport_ID(queueSupport.getAD_AppSupport_ID());
            processSender.setName("Engine as Queue");
            processSender.setDescription(DESCRIPTION);
            processSender.setVersionNo("1.0");
            processSender.setHost("localhost");
            processSender.setPort(29092);
            processSender.saveEx();
        }
    }
}

