/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.util;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.serialization.StringSerializer;
import org.spin.eca56.util.MapSerializer;

public class KafkaLoader {
    private static KafkaLoader instance;
    private HashMap<String, KafkaProducer<String, Object>> producers = new HashMap();

    public static KafkaLoader getInstance() {
        if (instance == null) {
            instance = new KafkaLoader();
        }
        return instance;
    }

    private void createTopic(String topic, HashMap<String, Object> cloud) {
        block8: {
            NewTopic newTopic = new NewTopic(topic, Optional.empty(), Optional.empty());
            try (AdminClient adminClient = AdminClient.create(cloud);){
                HashMap<String, String> topicConfigs = new HashMap<String, String>();
                topicConfigs.put("max.message.bytes", "20971520");
                topicConfigs.put("max.message.bytes", "20971520");
                newTopic.configs(topicConfigs);
                adminClient.createTopics(Collections.singletonList(newTopic)).all().get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (e.getCause() instanceof TopicExistsException) break block8;
                throw new RuntimeException(e);
            }
        }
    }

    public KafkaProducer<String, Object> getProducer(String url, String topic) throws Exception {
        String key = url + "|" + topic;
        KafkaProducer producer = this.producers.get(key);
        if (producer == null) {
            HashMap<String, Object> producerConfigs = new HashMap<String, Object>();
            producerConfigs.put("client.id", InetAddress.getLocalHost().getHostName());
            producerConfigs.put("bootstrap.servers", url);
            producerConfigs.put("key.serializer", StringSerializer.class.getName());
            producerConfigs.put("value.serializer", MapSerializer.class.getName());
            producerConfigs.put("acks", "all");
            producerConfigs.put("max.request.size", 0x300000);
            this.createTopic(topic, producerConfigs);
            producer = new KafkaProducer(producerConfigs);
            this.producers.put(key, (KafkaProducer<String, Object>)producer);
        }
        return producer;
    }
}

