/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.util.queue;

import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MLanguage;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.eca56.util.queue.DefaultEngineQueueUtil;
import org.spin.eca56.util.queue.IEngineDictionaryManager;
import org.spin.eca56.util.support.IGenericDictionaryDocument;
import org.spin.eca56.util.support.IGenericDocument;
import org.spin.eca56.util.support.IGenericSender;
import org.spin.eca56.util.support.documents.Browser;
import org.spin.eca56.util.support.documents.Form;
import org.spin.eca56.util.support.documents.Menu;
import org.spin.eca56.util.support.documents.Process;
import org.spin.eca56.util.support.documents.Window;
import org.spin.queue.model.MADQueue;
import org.spin.queue.util.QueueManager;

public class ApplicationDictionary
extends QueueManager
implements IEngineDictionaryManager {
    public static final String CODE = "ADM";

    public void add(int queueId) {
        logger.fine("Queue Added: " + queueId);
        try {
            this.send(queueId);
            MADQueue queue = new MADQueue(this.getContext(), queueId, this.getTransactionName());
            queue.setProcessed(true);
            queue.saveEx();
        }
        catch (Throwable e) {
            logger.warning(e.getLocalizedMessage());
        }
    }

    public void process(int queueId) {
        this.send(queueId);
    }

    public void send(int queueId) {
        PO entity = this.getEntity();
        if (entity != null) {
            IGenericSender sender = DefaultEngineQueueUtil.getEngineManager();
            if (sender == null) {
                throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
            }
            this.getLanguages().forEach(languageId -> {
                MLanguage language = new MLanguage(this.getContext(), languageId.intValue(), this.getTransactionName());
                IGenericDictionaryDocument documentByLanguage = this.getDocumentManager(entity, language.getAD_Language());
                if (documentByLanguage != null) {
                    sender.send(documentByLanguage, documentByLanguage.getChannel());
                }
                this.getRoles().forEach(roleId -> {
                    IGenericDictionaryDocument documentByRole = this.getDocumentManagerByRole(entity, language.getAD_Language(), (int)roleId);
                    if (documentByRole != null) {
                        sender.send(documentByRole, documentByRole.getChannel());
                    }
                });
                this.getUsers().forEach(userId -> {
                    IGenericDictionaryDocument documentByUser = this.getDocumentManagerByUser(entity, language.getAD_Language(), (int)userId);
                    if (documentByUser != null) {
                        sender.send(documentByUser, documentByUser.getChannel());
                    }
                });
            });
            logger.fine("Queue Processed: " + queueId);
        }
    }

    private List<Integer> getRoles() {
        return new Query(this.getContext(), "AD_Role", null, this.getTransactionName()).setClient_ID().setOnlyActiveRecords(true).getIDsAsList();
    }

    private List<Integer> getLanguages() {
        return new Query(this.getContext(), "AD_Language", "(IsBaseLanguage = 'Y' OR IsSystemLanguage = 'Y')", this.getTransactionName()).setOnlyActiveRecords(true).getIDsAsList();
    }

    private List<Integer> getUsers() {
        return new Query(this.getContext(), "AD_User", "(EXISTS(SELECT 1 FROM AD_WindowCustom wc WHERE wc.AD_User_ID = AD_User.AD_User_ID AND wc.IsActive = 'Y') OR EXISTS(SELECT 1 FROM AD_ProcessCustom wc WHERE wc.AD_User_ID = AD_User.AD_User_ID AND wc.IsActive = 'Y') OR EXISTS(SELECT 1 FROM AD_BrowseCustom wc WHERE wc.AD_User_ID = AD_User.AD_User_ID AND wc.IsActive = 'Y'))", this.getTransactionName()).setOnlyActiveRecords(true).setClient_ID().getIDsAsList();
    }

    @Override
    public IGenericDocument getDocumentManager(PO entity) {
        return null;
    }

    @Override
    public IGenericDictionaryDocument getDocumentManager(PO entity, String language) {
        String tableName = entity.get_TableName();
        if (Util.isEmpty((String)tableName)) {
            return null;
        }
        if (tableName.equals("AD_Process")) {
            return Process.newInstance().withLanguage(language).withClientId(Env.getAD_Client_ID((Properties)entity.getCtx())).withEntity(entity);
        }
        if (tableName.equals("AD_Browse")) {
            return Browser.newInstance().withLanguage(language).withClientId(Env.getAD_Client_ID((Properties)entity.getCtx())).withEntity(entity);
        }
        if (tableName.equals("AD_Window")) {
            return Window.newInstance().withLanguage(language).withClientId(Env.getAD_Client_ID((Properties)entity.getCtx())).withEntity(entity);
        }
        if (tableName.equals("AD_Menu")) {
            return Menu.newInstance().withLanguage(language).withClientId(Env.getAD_Client_ID((Properties)entity.getCtx())).withEntity(entity);
        }
        if (tableName.equals("AD_Form")) {
            return Form.newInstance().withLanguage(language).withClientId(Env.getAD_Client_ID((Properties)entity.getCtx())).withEntity(entity);
        }
        return null;
    }

    @Override
    public IGenericDictionaryDocument getDocumentManagerByRole(PO entity, String language, int roleId) {
        String tableName = entity.get_TableName();
        if (Util.isEmpty((String)tableName)) {
            return null;
        }
        if (tableName.equals("AD_Process")) {
            return null;
        }
        if (tableName.equals("AD_Browse")) {
            return null;
        }
        if (tableName.equals("AD_Window")) {
            return null;
        }
        if (tableName.equals("AD_Menu")) {
            return Menu.newInstance().withLanguage(language).withClientId(Env.getAD_Client_ID((Properties)entity.getCtx())).withRoleId(roleId).withEntity(entity);
        }
        return null;
    }

    @Override
    public IGenericDictionaryDocument getDocumentManagerByUser(PO entity, String language, int userId) {
        return null;
    }
}

