/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.util.queue;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.PO;
import org.compiere.util.Util;
import org.spin.eca56.util.queue.DefaultEngineQueueUtil;
import org.spin.eca56.util.queue.IEngineManager;
import org.spin.eca56.util.support.IGenericSender;
import org.spin.eca56.util.support.documents.Order;
import org.spin.queue.model.MADQueue;
import org.spin.queue.util.QueueManager;

public class DocumentManagement
extends QueueManager
implements IEngineManager {
    public static final String CODE = "DMM";

    public void add(int queueId) {
        logger.fine("Queue Added: " + queueId);
        try {
            this.send(queueId);
            MADQueue queue = new MADQueue(this.getContext(), queueId, this.getTransactionName());
            queue.setProcessed(true);
            queue.saveEx();
        }
        catch (Throwable e) {
            logger.warning(e.getLocalizedMessage());
        }
    }

    public void process(int queueId) {
        this.send(queueId);
    }

    private void send(int queueId) {
        PO document = this.getEntity();
        if (document != null) {
            Order entityEngine = this.getDocumentManager(document);
            if (entityEngine != null) {
                IGenericSender sender = DefaultEngineQueueUtil.getEngineManager();
                if (sender != null) {
                    sender.send(entityEngine, entityEngine.getChannel());
                } else {
                    throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
                }
            }
            logger.fine("Queue Processed: " + queueId);
        }
    }

    @Override
    public Order getDocumentManager(PO entity) {
        if (entity == null) {
            return null;
        }
        String tableName = entity.get_TableName();
        if (Util.isEmpty((String)tableName)) {
            return null;
        }
        if (tableName.equals("C_Order")) {
            return Order.newInstance().withOrder((MOrder)entity);
        }
        return null;
    }
}

