/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.util.support;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.spin.eca56.util.support.IGenericDictionaryDocument;

public abstract class DictionaryDocument
implements IGenericDictionaryDocument {
    private int clientId = -1;
    private int roleId = -1;
    private int userId = -1;
    private String language;
    private static final String KEY = "new";
    private String channel = "none";
    private Map<String, Object> document;

    public DictionaryDocument() {
        this.withLanguage(Env.getAD_Language((Properties)Env.getCtx()));
        this.document = new HashMap<String, Object>();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    @Override
    public Map<String, Object> getValues() {
        return this.document;
    }

    public void putDocument(Map<String, Object> document) {
        document.put("language", this.getLanguage());
        if (this.getClientId() >= 0) {
            document.put("client_id", this.getClientId());
        }
        if (this.getRoleId() >= 0) {
            document.put("role_id", this.getRoleId());
        }
        if (this.getUserId() >= 0) {
            document.put("user_id", this.getUserId());
        }
        document.put("index_value", this.getIndexValue());
        this.document.put("document", document);
    }

    @Override
    public DictionaryDocument withClientId(int clientId) {
        this.clientId = clientId;
        return this;
    }

    @Override
    public DictionaryDocument withRoleId(int roleId) {
        this.roleId = roleId;
        return this;
    }

    @Override
    public DictionaryDocument withUserId(int userId) {
        this.userId = userId;
        return this;
    }

    @Override
    public DictionaryDocument withLanguage(String language) {
        this.language = language;
        return this;
    }

    public int getClientId() {
        return this.clientId;
    }

    public int getRoleId() {
        return this.roleId;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getLanguage() {
        return this.language;
    }

    private String getIndexValue() {
        StringBuffer channel = new StringBuffer(this.getChannel());
        channel.append("_").append(this.getLanguage());
        if (this.getClientId() >= 0) {
            channel.append("_").append(this.getClientId());
        }
        if (this.getRoleId() >= 0) {
            channel.append("_").append(this.getRoleId());
        }
        if (this.getUserId() >= 0) {
            channel.append("_").append(this.getUserId());
        }
        return channel.toString().toLowerCase();
    }

    public DictionaryDocument withEntity(PO entity) {
        this.channel = entity.get_TableName().toLowerCase();
        HashMap<String, Object> documentDetail = new HashMap<String, Object>();
        documentDetail.put("id", entity.get_ID());
        documentDetail.put("uuid", entity.get_UUID());
        documentDetail.put("display_value", entity.getDisplayValue());
        this.putDocument(documentDetail);
        return this;
    }
}

