/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.util.support.documents;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MBrowseField;
import org.adempiere.model.MViewColumn;
import org.compiere.model.MColumn;
import org.compiere.model.MProcess;
import org.compiere.model.MTable;
import org.compiere.model.MWindow;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Util;
import org.spin.eca56.util.support.DictionaryDocument;
import org.spin.eca56.util.support.documents.DependenceUtil;
import org.spin.eca56.util.support.documents.ReferenceUtil;
import org.spin.eca56.util.support.documents.ReferenceValues;

public class Browser
extends DictionaryDocument {
    public static final String KEY = "new";
    public static final String CHANNEL = "browser";

    @Override
    public String getKey() {
        return KEY;
    }

    private Map<String, Object> parseDictionaryEntity(PO entity) {
        HashMap<String, Object> documentEntity = new HashMap<String, Object>();
        documentEntity.put("id", entity.get_ID());
        documentEntity.put("uuid", entity.get_UUID());
        documentEntity.put("name", entity.get_Translation("Name", this.getLanguage()));
        documentEntity.put("description", entity.get_Translation("Description", this.getLanguage()));
        documentEntity.put("help", entity.get_Translation("Help", this.getLanguage()));
        return documentEntity;
    }

    @Override
    public DictionaryDocument withEntity(PO entity) {
        Map<String, Object> referenceDetail;
        MBrowse browser = (MBrowse)entity;
        HashMap<String, Object> documentDetail = new HashMap<String, Object>();
        documentDetail.put("id", browser.getAD_Browse_ID());
        documentDetail.put("uuid", browser.getUUID());
        documentDetail.put("code", browser.getValue());
        documentDetail.put("name", browser.get_Translation("Name", this.getLanguage()));
        documentDetail.put("description", browser.get_Translation("Description", this.getLanguage()));
        documentDetail.put("help", browser.get_Translation("Help", this.getLanguage()));
        documentDetail.put("is_active", browser.isActive());
        documentDetail.put("is_execute_query_by_default", browser.isExecutedQueryByDefault());
        documentDetail.put("is_collapsible_by_default", browser.isCollapsibleByDefault());
        documentDetail.put("is_selected_by_default", browser.isSelectedByDefault());
        documentDetail.put("is_show_total", browser.isShowTotal());
        MBrowseField fieldKey = browser.getFieldKey();
        if (fieldKey != null && fieldKey.getAD_Browse_Field_ID() > 0) {
            MViewColumn viewColumn = MViewColumn.getById((Properties)browser.getCtx(), (int)fieldKey.getAD_View_Column_ID(), null);
            documentDetail.put("field_key", viewColumn.getColumnName());
        }
        documentDetail.put("access_level", browser.getAccessLevel());
        documentDetail.put("is_updateable", browser.isUpdateable());
        documentDetail.put("is_deleteable", browser.isUpdateable());
        if (browser.getAD_Table_ID() > 0) {
            MTable table = MTable.get((Properties)browser.getCtx(), (int)browser.getAD_Table_ID());
            documentDetail.put("table_name", table.getTableName());
        }
        documentDetail.put("process_id", browser.getAD_Process_ID());
        if (browser.getAD_Process_ID() > 0) {
            MProcess process = MProcess.get((Properties)browser.getCtx(), (int)browser.getAD_Process_ID());
            referenceDetail = this.parseDictionaryEntity((PO)process);
            documentDetail.put("process", referenceDetail);
        }
        documentDetail.put("window_id", browser.getAD_Window_ID());
        if (browser.getAD_Window_ID() > 0) {
            MWindow window = MWindow.get((Properties)browser.getCtx(), (int)browser.getAD_Window_ID());
            referenceDetail = this.parseDictionaryEntity((PO)window);
            documentDetail.put("window", referenceDetail);
        }
        documentDetail.put("context_column_names", ReferenceUtil.getContextColumnNames(Optional.ofNullable(browser.getWhereClause()).orElse("")));
        String whereClause = "AD_Browse_ID=?";
        List browseFields = new Query(browser.getCtx(), "AD_Browse_Field", "AD_Browse_ID=?", null).setParameters(new Object[]{browser.getAD_Browse_ID()}).setOrderBy("SeqNo").list();
        documentDetail.put("fields", this.convertFields(browseFields));
        this.putDocument(documentDetail);
        return this;
    }

    private List<Map<String, Object>> convertFields(List<MBrowseField> fields) {
        ArrayList<Map<String, Object>> fieldsDetail = new ArrayList<Map<String, Object>>();
        if (fields == null) {
            return fieldsDetail;
        }
        fields.forEach(field -> fieldsDetail.add(this.parseField((MBrowseField)field)));
        return fieldsDetail;
    }

    private Map<String, Object> parseField(MBrowseField field) {
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("id", field.getAD_Browse_Field_ID());
        detail.put("uuid", field.getUUID());
        detail.put("name", field.get_Translation("Name", this.getLanguage()));
        detail.put("description", field.get_Translation("Description", this.getLanguage()));
        detail.put("help", field.get_Translation("Help", this.getLanguage()));
        detail.put("is_active", field.isActive());
        detail.put("display_type", field.getAD_Reference_ID());
        detail.put("callout", field.getCallout());
        detail.put("is_order_by", field.isOrderBy());
        detail.put("sort_sequence", field.getSortNo());
        detail.put("is_key", field.isKey());
        detail.put("is_identifier", field.isIdentifier());
        MViewColumn viewColumn = MViewColumn.getById((Properties)field.getCtx(), (int)field.getAD_View_Column_ID(), null);
        String columnName = viewColumn.getColumnName();
        detail.put("column_name", columnName);
        detail.put("is_range", field.isRange());
        detail.put("default_value", field.getDefaultValue());
        detail.put("default_value_to", field.getDefaultValue2());
        detail.put("value_format", field.getVFormat());
        detail.put("min_value", field.getValueMin());
        detail.put("max_value", field.getValueMax());
        detail.put("is_displayed", field.isDisplayed());
        detail.put("is_query_criteria", field.isQueryCriteria());
        detail.put("display_logic", field.getDisplayLogic());
        detail.put("sequence", field.getSeqNo());
        detail.put("grid_sequence", field.getSeqNoGrid());
        detail.put("is_displayed_as_panel", field.isActive() && field.isQueryCriteria() ? "Y" : "N");
        detail.put("is_displayed_as_table", Character.valueOf((char)(field.isActive() && field.isDisplayed() ? 89 : 78)));
        detail.put("is_read_only", field.isReadOnly());
        detail.put("read_only_logic", field.getReadOnlyLogic());
        detail.put("is_info_only", field.isInfoOnly());
        detail.put("is_mandatory", field.isMandatory());
        String elementName = null;
        if (viewColumn.getAD_Column_ID() > 0) {
            MColumn column = MColumn.get((Properties)field.getCtx(), (int)viewColumn.getAD_Column_ID());
            elementName = column.getColumnName();
        }
        if (Util.isEmpty(elementName)) {
            elementName = field.getAD_Element().getColumnName();
        }
        detail.put("element_name", elementName);
        ReferenceValues referenceValues = ReferenceUtil.getReferenceDefinition(elementName, field.getAD_Reference_ID(), field.getAD_Reference_Value_ID(), field.getAD_Val_Rule_ID());
        if (referenceValues != null) {
            HashMap<String, Object> referenceDetail = new HashMap<String, Object>();
            referenceDetail.put("table_name", referenceValues.getTableName());
            referenceDetail.put("context_column_names", ReferenceUtil.getContextColumnNames(referenceValues.getEmbeddedContextColumn()));
            detail.put("reference", referenceDetail);
        }
        detail.put("context_column_names", ReferenceUtil.getContextColumnNames(Optional.ofNullable(field.getDefaultValue()).orElse("") + Optional.ofNullable(field.getDefaultValue2()).orElse("")));
        detail.put("dependent_fields", DependenceUtil.generateDependentBrowseFields(field));
        return detail;
    }

    private Browser() {
    }

    public static Browser newInstance() {
        return new Browser();
    }

    @Override
    public String getChannel() {
        return CHANNEL;
    }
}

