/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.util.support.documents;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MBrowseField;
import org.adempiere.model.MViewColumn;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTab;
import org.compiere.model.MValRule;
import org.compiere.model.MWindow;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class DependenceUtil {
    public static boolean isUseParentColumnOnContext(String columnName, String context) {
        if (Util.isEmpty((String)columnName, (boolean)true)) {
            return false;
        }
        if (Util.isEmpty((String)context, (boolean)true)) {
            return false;
        }
        StringBuffer patternValue = new StringBuffer().append("@").append("($|#){0,1}").append(columnName).append("(@)");
        Pattern pattern = Pattern.compile(patternValue.toString(), 34);
        Matcher matcher = pattern.matcher(context);
        boolean isUsedParentColumn = matcher.find();
        if (!isUsedParentColumn) {
            patternValue.append("{0,1}");
            Pattern pattern2 = Pattern.compile(patternValue.toString(), 34);
            Matcher matcher2 = pattern2.matcher(context);
            isUsedParentColumn = matcher2.find();
        }
        return isUsedParentColumn;
    }

    public static List<Map<String, Object>> generateDependentProcessParameters(MProcessPara processParameter) {
        ArrayList<Map<String, Object>> depenentFieldsList = new ArrayList<Map<String, Object>>();
        if (processParameter == null) {
            return depenentFieldsList;
        }
        String parentColumnName = processParameter.getColumnName();
        MProcess process = MProcess.get((Properties)processParameter.getCtx(), (int)processParameter.getAD_Process_ID());
        List parametersList = process.getParametersAsList();
        if (parametersList == null || parametersList.isEmpty()) {
            return depenentFieldsList;
        }
        parametersList.parallelStream().filter(currentParameter -> {
            MValRule validationRule;
            if (!currentParameter.isActive()) {
                return false;
            }
            if (DependenceUtil.isUseParentColumnOnContext(parentColumnName, currentParameter.getDisplayLogic())) {
                return true;
            }
            if (DependenceUtil.isUseParentColumnOnContext(parentColumnName, currentParameter.getDefaultValue())) {
                return true;
            }
            if (DependenceUtil.isUseParentColumnOnContext(parentColumnName, currentParameter.getReadOnlyLogic())) {
                return true;
            }
            return currentParameter.getAD_Val_Rule_ID() > 0 && DependenceUtil.isUseParentColumnOnContext(parentColumnName, (validationRule = MValRule.get((Properties)Env.getCtx(), (int)currentParameter.getAD_Val_Rule_ID())).getCode());
        }).forEach(currentParameter -> {
            HashMap<String, Object> detail = new HashMap<String, Object>();
            detail.put("id", currentParameter.getAD_Process_Para_ID());
            detail.put("uuid", currentParameter.getUUID());
            detail.put("column_name", currentParameter.getColumnName());
            detail.put("parent_id", process.getAD_Process_ID());
            detail.put("parent_uuid", process.getUUID());
            detail.put("parent_name", process.getName());
            depenentFieldsList.add(detail);
        });
        return depenentFieldsList;
    }

    public static List<Map<String, Object>> generateDependentWindowFields(MField field) {
        ArrayList<Map<String, Object>> depenentFieldsList = new ArrayList<Map<String, Object>>();
        if (field == null) {
            return depenentFieldsList;
        }
        String parentColumnName = MColumn.getColumnName((Properties)field.getCtx(), (int)field.getAD_Column_ID());
        MTab parentTab = MTab.get((Properties)field.getCtx(), (int)field.getAD_Tab_ID());
        List<MTab> tabsList = Arrays.asList(MWindow.get((Properties)field.getCtx(), (int)parentTab.getAD_Window_ID()).getTabs(false, null));
        if (tabsList == null || tabsList.isEmpty()) {
            return depenentFieldsList;
        }
        tabsList.parallelStream().filter(currentTab -> currentTab.isActive() && !currentTab.isTranslationTab() && !currentTab.isSortTab()).forEach(tab -> {
            List<MField> fieldsList = Arrays.asList(tab.getFields(false, null));
            if (fieldsList == null || fieldsList.isEmpty()) {
                return;
            }
            fieldsList.parallelStream().filter(currentField -> {
                MValRule validationRule;
                MValRule validationRule2;
                if (!currentField.isActive()) {
                    return false;
                }
                if (DependenceUtil.isUseParentColumnOnContext(parentColumnName, currentField.getDisplayLogic())) {
                    return true;
                }
                if (DependenceUtil.isUseParentColumnOnContext(parentColumnName, currentField.getDefaultValue())) {
                    return true;
                }
                if (currentField.getAD_Val_Rule_ID() > 0 && DependenceUtil.isUseParentColumnOnContext(parentColumnName, (validationRule2 = MValRule.get((Properties)Env.getCtx(), (int)currentField.getAD_Val_Rule_ID())).getCode())) {
                    return true;
                }
                MColumn currentColumn = MColumn.get((Properties)Env.getCtx(), (int)currentField.getAD_Column_ID());
                if (DependenceUtil.isUseParentColumnOnContext(parentColumnName, currentColumn.getDefaultValue())) {
                    return true;
                }
                if (DependenceUtil.isUseParentColumnOnContext(parentColumnName, currentColumn.getReadOnlyLogic())) {
                    return true;
                }
                if (DependenceUtil.isUseParentColumnOnContext(parentColumnName, currentColumn.getMandatoryLogic())) {
                    return true;
                }
                return currentColumn.getAD_Val_Rule_ID() > 0 && DependenceUtil.isUseParentColumnOnContext(parentColumnName, (validationRule = MValRule.get((Properties)Env.getCtx(), (int)currentColumn.getAD_Val_Rule_ID())).getCode());
            }).forEach(currentField -> {
                String currentColumnName = MColumn.getColumnName((Properties)Env.getCtx(), (int)currentField.getAD_Column_ID());
                HashMap<String, Object> detail = new HashMap<String, Object>();
                detail.put("id", currentField.getAD_Field_ID());
                detail.put("uuid", currentField.getUUID());
                detail.put("column_name", currentColumnName);
                detail.put("parent_id", tab.getAD_Tab_ID());
                detail.put("parent_uuid", tab.getUUID());
                detail.put("parent_name", tab.getName());
                depenentFieldsList.add(detail);
            });
        });
        return depenentFieldsList;
    }

    public static List<Map<String, Object>> generateDependentBrowseFields(MBrowseField browseField) {
        ArrayList<Map<String, Object>> depenentFieldsList = new ArrayList<Map<String, Object>>();
        if (browseField == null) {
            return depenentFieldsList;
        }
        MViewColumn viewColumn = MViewColumn.getById((Properties)Env.getCtx(), (int)browseField.getAD_View_Column_ID(), null);
        String parentColumnName = viewColumn.getColumnName();
        String elementName = null;
        if (viewColumn.getAD_Column_ID() != 0) {
            MColumn column = MColumn.get((Properties)Env.getCtx(), (int)viewColumn.getAD_Column_ID());
            elementName = column.getColumnName();
        }
        if (Util.isEmpty(elementName, (boolean)true)) {
            elementName = browseField.getAD_Element().getColumnName();
        }
        String parentElementName = elementName;
        MBrowse browse = MBrowse.get((Properties)browseField.getCtx(), (int)browseField.getAD_Browse_ID());
        List browseFieldsList = browse.getFields();
        if (browseFieldsList == null || browseFieldsList.isEmpty()) {
            return depenentFieldsList;
        }
        browseFieldsList.parallelStream().filter(currentBrowseField -> {
            MValRule validationRule;
            if (!currentBrowseField.isActive()) {
                return false;
            }
            if (DependenceUtil.isUseParentColumnOnContext(parentColumnName, currentBrowseField.getDisplayLogic()) || DependenceUtil.isUseParentColumnOnContext(parentElementName, currentBrowseField.getDisplayLogic())) {
                return true;
            }
            if (DependenceUtil.isUseParentColumnOnContext(parentColumnName, currentBrowseField.getDefaultValue()) || DependenceUtil.isUseParentColumnOnContext(parentElementName, currentBrowseField.getDefaultValue())) {
                return true;
            }
            if (DependenceUtil.isUseParentColumnOnContext(parentColumnName, currentBrowseField.getDefaultValue2()) || DependenceUtil.isUseParentColumnOnContext(parentElementName, currentBrowseField.getDefaultValue2())) {
                return true;
            }
            if (DependenceUtil.isUseParentColumnOnContext(parentColumnName, currentBrowseField.getReadOnlyLogic()) || DependenceUtil.isUseParentColumnOnContext(parentElementName, currentBrowseField.getReadOnlyLogic())) {
                return true;
            }
            return currentBrowseField.getAD_Val_Rule_ID() > 0 && (DependenceUtil.isUseParentColumnOnContext(parentColumnName, (validationRule = MValRule.get((Properties)Env.getCtx(), (int)currentBrowseField.getAD_Val_Rule_ID())).getCode()) || DependenceUtil.isUseParentColumnOnContext(parentElementName, validationRule.getCode()));
        }).forEach(currentBrowseField -> {
            MViewColumn currentViewColumn = MViewColumn.getById((Properties)Env.getCtx(), (int)currentBrowseField.getAD_View_Column_ID(), null);
            HashMap<String, Object> detail = new HashMap<String, Object>();
            detail.put("id", currentBrowseField.getAD_Browse_Field_ID());
            detail.put("uuid", currentBrowseField.getUUID());
            detail.put("column_name", currentViewColumn.getColumnName());
            detail.put("parent_id", browse.getAD_Browse_ID());
            detail.put("parent_uuid", browse.getUUID());
            detail.put("parent_name", browse.getName());
            depenentFieldsList.add(detail);
        });
        return depenentFieldsList;
    }
}

