/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.util.support.documents;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.adempiere.model.MBrowse;
import org.compiere.model.MClientInfo;
import org.compiere.model.MForm;
import org.compiere.model.MMenu;
import org.compiere.model.MProcess;
import org.compiere.model.MRole;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.MWindow;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.spin.eca56.util.support.DictionaryDocument;

public class Menu
extends DictionaryDocument {
    public static final String CHANNEL = "menu";
    public static final String KEY = "new";

    @Override
    public String getKey() {
        return KEY;
    }

    private void addChildren(MTreeNode node, Map<String, Object> parent) {
        Enumeration childrens = node.children();
        ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
        while (childrens.hasMoreElements()) {
            MTreeNode childNode = (MTreeNode)childrens.nextElement();
            Map<String, Object> child = this.convertNode(childNode);
            this.addChildren(childNode, child);
            children.add(child);
        }
        parent.put("children", children);
    }

    private Map<String, Object> convertNode(MTreeNode node) {
        MMenu menu = MMenu.getFromId((Properties)Env.getCtx(), (int)node.getNode_ID());
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("id", menu.getAD_Menu_ID());
        detail.put("uuid", menu.getUUID());
        detail.put("name", menu.get_Translation("Name", this.getLanguage()));
        detail.put("description", menu.get_Translation("Description", this.getLanguage()));
        detail.put("parent_id", node.getParent_ID());
        detail.put("sequence", Integer.parseInt(node.getSeqNo()));
        detail.put("is_read_only", menu.isReadOnly());
        detail.put("is_sales_transaction", menu.isSOTrx());
        detail.put("is_summary", menu.isSummary());
        detail.put("action", menu.getAction());
        if (!Util.isEmpty((String)menu.getAction())) {
            if (menu.getAction().equals("X")) {
                if (menu.getAD_Form_ID() > 0) {
                    MForm form = new MForm(menu.getCtx(), menu.getAD_Form_ID(), null);
                    HashMap<String, Object> referenceDetail = new HashMap<String, Object>();
                    referenceDetail.put("id", form.getAD_Form_ID());
                    referenceDetail.put("uuid", form.getUUID());
                    referenceDetail.put("name", form.get_Translation("Name", this.getLanguage()));
                    referenceDetail.put("description", form.get_Translation("Description", this.getLanguage()));
                    referenceDetail.put("help", form.get_Translation("Help", this.getLanguage()));
                    detail.put("form", referenceDetail);
                    detail.put("action_id", form.getAD_Form_ID());
                    detail.put("action_uuid", form.getUUID());
                }
            } else if (menu.getAction().equals("W")) {
                if (menu.getAD_Window_ID() > 0) {
                    MWindow window = new MWindow(menu.getCtx(), menu.getAD_Window_ID(), null);
                    HashMap<String, Object> referenceDetail = new HashMap<String, Object>();
                    referenceDetail.put("id", window.getAD_Window_ID());
                    referenceDetail.put("uuid", window.getUUID());
                    referenceDetail.put("name", window.get_Translation("Name", this.getLanguage()));
                    referenceDetail.put("description", window.get_Translation("Description", this.getLanguage()));
                    referenceDetail.put("help", window.get_Translation("Help", this.getLanguage()));
                    detail.put("window", referenceDetail);
                    detail.put("action_id", window.getAD_Window_ID());
                    detail.put("action_uuid", window.getUUID());
                }
            } else if (menu.getAction().equals("P") || menu.getAction().equals("R")) {
                if (menu.getAD_Process_ID() > 0) {
                    MProcess process = MProcess.get((Properties)menu.getCtx(), (int)menu.getAD_Process_ID());
                    HashMap<String, Object> referenceDetail = new HashMap<String, Object>();
                    referenceDetail.put("id", process.getAD_Process_ID());
                    referenceDetail.put("uuid", process.getUUID());
                    referenceDetail.put("name", process.get_Translation("Name", this.getLanguage()));
                    referenceDetail.put("description", process.get_Translation("Description", this.getLanguage()));
                    referenceDetail.put("help", process.get_Translation("Help", this.getLanguage()));
                    detail.put("process", referenceDetail);
                    detail.put("action_id", process.getAD_Process_ID());
                    detail.put("action_uuid", process.getUUID());
                }
            } else if (menu.getAction().equals("S")) {
                if (menu.getAD_Browse_ID() > 0) {
                    MBrowse smartBrowser = MBrowse.get((Properties)menu.getCtx(), (int)menu.getAD_Browse_ID());
                    HashMap<String, Object> referenceDetail = new HashMap<String, Object>();
                    referenceDetail.put("id", smartBrowser.getAD_Browse_ID());
                    referenceDetail.put("uuid", smartBrowser.getUUID());
                    referenceDetail.put("name", smartBrowser.get_Translation("Name", this.getLanguage()));
                    referenceDetail.put("description", smartBrowser.get_Translation("Description", this.getLanguage()));
                    referenceDetail.put("help", smartBrowser.get_Translation("Help", this.getLanguage()));
                    detail.put("browse", referenceDetail);
                    detail.put("action_id", smartBrowser.getAD_Browse_ID());
                    detail.put("action_uuid", smartBrowser.getUUID());
                }
            } else if (menu.getAction().equals("F") && menu.getAD_Workflow_ID() > 0) {
                MWorkflow workflow = MWorkflow.get((Properties)menu.getCtx(), (int)menu.getAD_Workflow_ID());
                HashMap<String, Object> referenceDetail = new HashMap<String, Object>();
                referenceDetail.put("id", workflow.getAD_Workflow_ID());
                referenceDetail.put("uuid", workflow.getUUID());
                referenceDetail.put("name", workflow.get_Translation("Name", this.getLanguage()));
                referenceDetail.put("description", workflow.get_Translation("Description", this.getLanguage()));
                referenceDetail.put("help", workflow.get_Translation("Help", this.getLanguage()));
                detail.put("workflow", referenceDetail);
                detail.put("action_id", workflow.getAD_Workflow_ID());
                detail.put("action_uuid", workflow.getUUID());
            }
        }
        return detail;
    }

    @Override
    public DictionaryDocument withEntity(PO entity) {
        MMenu menu = (MMenu)entity;
        MClientInfo clientInfo = MClientInfo.get((Properties)menu.getCtx());
        int currentRoleId = Env.getAD_Role_ID((Properties)menu.getCtx());
        if (this.getRoleId() >= 0) {
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)this.getRoleId());
        }
        MRole.getDefault((Properties)menu.getCtx(), (boolean)true);
        MTree tree = new MTree(menu.getCtx(), clientInfo.getAD_Tree_Menu_ID(), false, false, null, null);
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)currentRoleId);
        MTreeNode rootNode = tree.getRoot();
        return this.withNode(rootNode.findNode(menu.getAD_Menu_ID()));
    }

    public Menu withNode(MTreeNode node) {
        if (node == null) {
            return this;
        }
        Enumeration childrens = node.children();
        Map<String, Object> documentDetail = this.convertNode(node);
        ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
        while (childrens.hasMoreElements()) {
            MTreeNode childNode = (MTreeNode)childrens.nextElement();
            Map<String, Object> child = this.convertNode(childNode);
            this.addChildren(childNode, child);
            children.add(child);
        }
        documentDetail.put("children", children);
        this.putDocument(documentDetail);
        return this;
    }

    private Menu() {
    }

    public static Menu newInstance() {
        return new Menu();
    }

    @Override
    public String getChannel() {
        return CHANNEL;
    }
}

