/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.util.support.documents;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.spin.eca56.util.support.IGenericDocument;

public class Order
implements IGenericDocument {
    public static final String KEY = "new";
    public static final String CHANNEL = "order";
    private Map<String, Object> document;

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public Map<String, Object> getValues() {
        return this.document;
    }

    public Order withOrder(MOrder order) {
        this.document = new HashMap<String, Object>();
        HashMap<String, Object> documentDetail = new HashMap<String, Object>();
        documentDetail.put("id", order.getC_Order_ID());
        documentDetail.put("uuid", order.getUUID());
        documentDetail.put("document_no", order.getDocumentNo());
        documentDetail.put("document_type_id", order.getC_DocTypeTarget_ID());
        documentDetail.put("description", order.getDescription());
        documentDetail.put("business_partner_id", order.getC_BPartner_ID());
        documentDetail.put("total_lines", order.getTotalLines());
        documentDetail.put("grand_total", order.getGrandTotal());
        List<MOrderLine> orderLines = Arrays.asList(order.getLines(true, "Line"));
        ArrayList orderLinesDetail = new ArrayList();
        if (orderLines != null) {
            orderLines.forEach(orderLine -> {
                HashMap<String, Object> detail = new HashMap<String, Object>();
                detail.put("id", orderLine.getC_OrderLine_ID());
                detail.put("uuid", orderLine.getUUID());
                detail.put("name", orderLine.getName());
                detail.put("description", orderLine.getDescription());
                detail.put("product_id", orderLine.getM_Product_ID());
                detail.put("quantity_entered", orderLine.getQtyEntered());
                detail.put("quantity_ordered", orderLine.getQtyOrdered());
                detail.put("price_entered", orderLine.getPriceEntered());
                detail.put("price_actual", orderLine.getPriceLimit());
                detail.put("price_list", orderLine.getPriceList());
                detail.put("uom_id", orderLine.getC_UOM_ID());
                orderLinesDetail.add(detail);
            });
        }
        documentDetail.put("lines", orderLinesDetail);
        this.document.put(KEY, documentDetail);
        return this;
    }

    public static Order newInstance() {
        return new Order();
    }

    @Override
    public String getChannel() {
        return CHANNEL;
    }
}

