/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.util.support.documents;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.model.MBrowse;
import org.compiere.model.MForm;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MReportView;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.wf.MWorkflow;
import org.spin.eca56.util.support.DictionaryDocument;
import org.spin.eca56.util.support.documents.DependenceUtil;
import org.spin.eca56.util.support.documents.ReferenceUtil;
import org.spin.eca56.util.support.documents.ReferenceValues;
import org.spin.util.AbstractExportFormat;
import org.spin.util.ReportExportHandler;

public class Process
extends DictionaryDocument {
    public static final String KEY = "new";
    public static final String CHANNEL = "process";

    @Override
    public String getKey() {
        return KEY;
    }

    private Map<String, Object> parseDictionaryEntity(PO entity) {
        HashMap<String, Object> documentEntity = new HashMap<String, Object>();
        documentEntity.put("id", entity.get_ID());
        documentEntity.put("uuid", entity.get_UUID());
        documentEntity.put("name", entity.get_Translation("Name", this.getLanguage()));
        documentEntity.put("description", entity.get_Translation("Description", this.getLanguage()));
        documentEntity.put("help", entity.get_Translation("Help", this.getLanguage()));
        return documentEntity;
    }

    @Override
    public DictionaryDocument withEntity(PO entity) {
        MProcess process = (MProcess)entity;
        HashMap<String, Object> documentDetail = new HashMap<String, Object>();
        documentDetail.put("id", process.getAD_Process_ID());
        documentDetail.put("uuid", process.getUUID());
        documentDetail.put("code", process.getValue());
        documentDetail.put("name", process.get_Translation("Name", this.getLanguage()));
        documentDetail.put("description", process.get_Translation("Description", this.getLanguage()));
        documentDetail.put("help", process.get_Translation("Help", this.getLanguage()));
        documentDetail.put("is_active", process.isActive());
        documentDetail.put("show_help", process.getShowHelp());
        documentDetail.put("is_report", process.isReport());
        if (process.isReport()) {
            documentDetail.put("report_view_id", process.getAD_ReportView_ID());
            documentDetail.put("print_format_id", process.getAD_PrintFormat_ID());
            MReportView reportView = null;
            if (process.getAD_ReportView_ID() > 0) {
                reportView = MReportView.get((Properties)entity.getCtx(), (int)process.getAD_ReportView_ID());
            }
            ReportExportHandler exportHandler = new ReportExportHandler(entity.getCtx(), reportView);
            HashMap<String, String> reportExportReference = new HashMap<String, String>();
            for (AbstractExportFormat reportType : exportHandler.getExportFormatList()) {
                reportExportReference.put("name", reportType.getName());
                reportExportReference.put("type", reportType.getExtension());
            }
            documentDetail.put("report_export_types", reportExportReference);
        }
        documentDetail.put("browser_id", process.getAD_Browse_ID());
        documentDetail.put("form_id", process.getAD_Form_ID());
        documentDetail.put("workflow_id", process.getAD_Workflow_ID());
        if (process.getAD_Browse_ID() > 0) {
            MBrowse browse = MBrowse.get((Properties)process.getCtx(), (int)process.getAD_Browse_ID());
            documentDetail.put("browse", this.parseDictionaryEntity((PO)browse));
        } else if (process.getAD_Form_ID() > 0) {
            MForm form = new MForm(process.getCtx(), process.getAD_Form_ID(), null);
            documentDetail.put("form", this.parseDictionaryEntity((PO)form));
        } else if (process.getAD_Workflow_ID() > 0) {
            MWorkflow workflow = MWorkflow.get((Properties)process.getCtx(), (int)process.getAD_Workflow_ID());
            documentDetail.put("workflow", this.parseDictionaryEntity((PO)workflow));
        }
        StringBuffer whereClause = new StringBuffer("AD_Process_ID=?");
        List parameters = new Query(process.getCtx(), "AD_Process_Para", whereClause.toString(), null).setParameters(new Object[]{process.getAD_Process_ID()}).setOrderBy("SeqNo").list();
        boolean hasParameters = parameters != null && !parameters.isEmpty();
        documentDetail.put("has_parameters", hasParameters);
        ArrayList parametersDetail = new ArrayList();
        if (hasParameters) {
            parameters.forEach(parameter -> {
                Map<String, Object> detail = this.parseProcessParameter((MProcessPara)parameter);
                parametersDetail.add(detail);
            });
        }
        documentDetail.put("parameters", parametersDetail);
        this.putDocument(documentDetail);
        return this;
    }

    Map<String, Object> parseProcessParameter(MProcessPara parameter) {
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("id", parameter.getAD_Process_Para_ID());
        detail.put("uuid", parameter.getUUID());
        detail.put("column_name", parameter.getColumnName());
        detail.put("name", parameter.get_Translation("Name", this.getLanguage()));
        detail.put("description", parameter.get_Translation("Description", this.getLanguage()));
        detail.put("help", parameter.get_Translation("Help", this.getLanguage()));
        detail.put("is_active", parameter.isActive());
        detail.put("display_type", parameter.getAD_Reference_ID());
        detail.put("is_range", parameter.isRange());
        detail.put("default_value", parameter.getDefaultValue());
        detail.put("default_value_to", parameter.getDefaultValue2());
        detail.put("field_length", parameter.getFieldLength());
        detail.put("value_format", parameter.getVFormat());
        detail.put("min_value", parameter.getValueMin());
        detail.put("max_value", parameter.getValueMax());
        detail.put("display_logic", parameter.getDisplayLogic());
        detail.put("sequence", parameter.getSeqNo());
        detail.put("is_displayed_as_panel", parameter.isActive() ? "Y" : "N");
        detail.put("is_mandatory", parameter.isMandatory());
        detail.put("read_only_logic", parameter.getReadOnlyLogic());
        detail.put("is_info_only", parameter.isInfoOnly());
        ReferenceValues referenceValues = ReferenceUtil.getReferenceDefinition(parameter.getColumnName(), parameter.getAD_Reference_ID(), parameter.getAD_Reference_Value_ID(), parameter.getAD_Val_Rule_ID());
        if (referenceValues != null) {
            HashMap<String, Object> referenceDetail = new HashMap<String, Object>();
            referenceDetail.put("table_name", referenceValues.getTableName());
            referenceDetail.put("context_column_names", ReferenceUtil.getContextColumnNames(referenceValues.getEmbeddedContextColumn()));
            detail.put("reference", referenceDetail);
        }
        detail.put("context_column_names", ReferenceUtil.getContextColumnNames(Optional.ofNullable(parameter.getDefaultValue()).orElse("") + Optional.ofNullable(parameter.getDefaultValue2()).orElse("")));
        detail.put("dependent_fields", DependenceUtil.generateDependentProcessParameters(parameter));
        return detail;
    }

    private Process() {
    }

    public static Process newInstance() {
        return new Process();
    }

    @Override
    public String getChannel() {
        return CHANNEL;
    }
}

