/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.util.support.documents;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.compiere.model.MRefTable;
import org.compiere.model.MValRule;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.eca56.util.support.documents.ReferenceValues;

public class ReferenceUtil {
    public static boolean isLookupReference(int displayTypeId) {
        return DisplayType.isLookup((int)displayTypeId) || 25 == displayTypeId || 13 == displayTypeId || 21 == displayTypeId || 31 == displayTypeId || 32 == displayTypeId || 35 == displayTypeId;
    }

    public static List<String> getContextColumnNames(String context) {
        if (Util.isEmpty((String)context, (boolean)true)) {
            return new ArrayList<String>();
        }
        String START = "\\@";
        String END = "\\@";
        String patternValue = START + "(#|$){0,1}(\\w+)" + END;
        Pattern pattern = Pattern.compile(patternValue);
        Matcher matcher = pattern.matcher(context);
        HashMap<String, Boolean> columnNamesMap = new HashMap<String, Boolean>();
        while (matcher.find()) {
            columnNamesMap.put(matcher.group().replace("@", "").replace("@", ""), true);
        }
        return new ArrayList<String>(columnNamesMap.keySet());
    }

    public static ReferenceValues getReferenceDefinition(String columnName, int referenceId, int referenceValueId, int validationRuleId) {
        String embeddedContextColumn = null;
        if (referenceId > 0 && ReferenceUtil.isLookupReference(referenceId)) {
            MRefTable tableReference;
            HashMap<String, Integer> referenceDetail = new HashMap<String, Integer>();
            referenceDetail.put("id", referenceId);
            String tableName = ReferenceUtil.getTableNameFromReference(columnName, referenceId);
            String whereClauseReference = null;
            String validationRuleValue = null;
            if (validationRuleId > 0) {
                MValRule validationRule = MValRule.get((Properties)Env.getCtx(), (int)validationRuleId);
                validationRuleValue = validationRule.getCode();
            }
            if ((referenceId == 18 || referenceId == 30) && referenceValueId > 0 && (tableReference = MRefTable.getById((Properties)Env.getCtx(), (int)referenceValueId)) != null) {
                whereClauseReference = tableReference.getWhereClause();
            }
            embeddedContextColumn = (String)Optional.ofNullable(whereClauseReference).orElse("") + Optional.ofNullable(validationRuleValue).orElse("");
            return ReferenceValues.newInstance(referenceId, tableName, embeddedContextColumn);
        }
        return null;
    }

    public static String getTableNameFromReference(String columnName, int referenceId) {
        String tableName = null;
        if (13 == referenceId || 30 == referenceId || 18 == referenceId || 19 == referenceId) {
            tableName = columnName.replaceAll("(_ID_To|_To_ID|_ID)$", "");
        } else if (17 == referenceId) {
            tableName = "AD_Reference";
        } else if (21 == referenceId) {
            tableName = "C_Location";
        } else if (31 == referenceId) {
            tableName = "M_Locator";
        } else if (35 == referenceId) {
            tableName = "M_AttributeSetInstance";
        } else if (32 == referenceId) {
            tableName = "AD_Image";
        } else if (33 == referenceId) {
            tableName = "S_ResourceAssignment";
        } else if (53370 == referenceId) {
            tableName = "AD_Chart";
        } else if (25 == referenceId) {
            tableName = "C_ElementValue";
        }
        return tableName;
    }
}

