/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.util.support.documents;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_AD_Column;
import org.adempiere.model.MBrowse;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MForm;
import org.compiere.model.MProcess;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.model.MWindow;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.wf.MWorkflow;
import org.spin.eca56.util.support.DictionaryDocument;
import org.spin.eca56.util.support.documents.DependenceUtil;
import org.spin.eca56.util.support.documents.ReferenceUtil;
import org.spin.eca56.util.support.documents.ReferenceValues;

public class Window
extends DictionaryDocument {
    public static final String KEY = "new";
    public static final String CHANNEL = "window";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public DictionaryDocument withEntity(PO entity) {
        MWindow window = (MWindow)entity;
        HashMap<String, Object> documentDetail = new HashMap<String, Object>();
        documentDetail.put("id", window.getAD_Window_ID());
        documentDetail.put("uuid", window.getUUID());
        documentDetail.put("name", window.get_Translation("Name", this.getLanguage()));
        documentDetail.put("description", window.get_Translation("Description", this.getLanguage()));
        documentDetail.put("help", window.get_Translation("Help", this.getLanguage()));
        documentDetail.put("window_type", window.getWindowType());
        documentDetail.put("is_sales_transaction", window.isSOTrx());
        documentDetail.put("is_active", window.isActive());
        documentDetail.put("tabs", this.convertTabs(Arrays.asList(window.getTabs(false, null))));
        this.putDocument(documentDetail);
        return this;
    }

    private Map<String, Object> parseDictionaryEntity(PO entity) {
        HashMap<String, Object> documentEntity = new HashMap<String, Object>();
        documentEntity.put("id", entity.get_ID());
        documentEntity.put("uuid", entity.get_UUID());
        documentEntity.put("name", entity.get_Translation("Name", this.getLanguage()));
        documentEntity.put("description", entity.get_Translation("Description", this.getLanguage()));
        documentEntity.put("help", entity.get_Translation("Help", this.getLanguage()));
        return documentEntity;
    }

    private List<Map<String, Object>> convertTabs(List<MTab> tabs) {
        ArrayList<Map<String, Object>> tabsDetail = new ArrayList<Map<String, Object>>();
        if (tabs == null || tabs.isEmpty()) {
            return tabsDetail;
        }
        tabs.forEach(tab -> {
            if (!tab.isActive()) {
                return;
            }
            tabsDetail.add(this.parseTab((MTab)tab));
        });
        return tabsDetail;
    }

    private Map<String, Object> parseTab(MTab tab) {
        MProcess process;
        MColumn column2;
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("id", tab.getAD_Tab_ID());
        detail.put("uuid", tab.getUUID());
        detail.put("name", tab.get_Translation("Name", this.getLanguage()));
        detail.put("description", tab.get_Translation("Description", this.getLanguage()));
        detail.put("help", tab.get_Translation("Help", this.getLanguage()));
        detail.put("is_active", tab.isActive());
        detail.put("is_insert_record", tab.isInsertRecord());
        detail.put("commit_warning", tab.get_Translation("CommitWarning", this.getLanguage()));
        detail.put("display_logic", tab.getDisplayLogic());
        detail.put("sequence", tab.getSeqNo());
        detail.put("tab_level", tab.getTabLevel());
        detail.put("is_read_only", tab.isReadOnly());
        detail.put("read_only_logic", tab.getReadOnlyLogic());
        detail.put("is_single_row", tab.isSingleRow());
        detail.put("is_advanced_tab", tab.isAdvancedTab());
        detail.put("is_has_tree", tab.isHasTree());
        detail.put("is_info_tab", tab.isInfoTab());
        detail.put("is_translation_tab", tab.isTranslationTab());
        MTable table = MTable.get((Properties)tab.getCtx(), (int)tab.getAD_Table_ID());
        detail.put("table_name", table.getTableName());
        HashMap<String, Object> tableDetil = new HashMap<String, Object>();
        tableDetil.put("table_name", table.getTableName());
        tableDetil.put("access_level", table.getAccessLevel());
        List<String> keyColumnsList = Arrays.asList(table.getKeyColumns());
        tableDetil.put("key_columns", keyColumnsList);
        tableDetil.put("is_view", table.isView());
        tableDetil.put("is_document", table.isDocument());
        tableDetil.put("is_deleteable", table.isDeleteable());
        tableDetil.put("is_change_log", table.isChangeLog());
        List identifierColumns = table.getColumnsAsList(false).stream().filter(column -> column.isIdentifier()).sorted(Comparator.comparing(X_AD_Column::getSeqNo)).map(column -> column.getColumnName()).collect(Collectors.toList());
        tableDetil.put("identifier_columns", identifierColumns);
        List selectionColums = table.getColumnsAsList(false).stream().filter(column -> column.isSelectionColumn()).map(column -> column.getColumnName()).collect(Collectors.toList());
        tableDetil.put("selection_colums", selectionColums);
        detail.put("table_name", table.getTableName());
        detail.put("table", tableDetil);
        ArrayList<String> contextColumnsList = new ArrayList<String>();
        contextColumnsList.addAll(ReferenceUtil.getContextColumnNames(Optional.ofNullable(tab.getWhereClause()).orElse("") + Optional.ofNullable(tab.getOrderByClause()).orElse("")));
        if (tab.getParent_Column_ID() > 0) {
            column2 = MColumn.get((Properties)tab.getCtx(), (int)tab.getParent_Column_ID());
            detail.put("parent_column_name", column2.getColumnName());
            if (!contextColumnsList.contains(column2.getColumnName())) {
                contextColumnsList.add(column2.getColumnName());
            }
        }
        if (tab.getAD_Column_ID() > 0) {
            column2 = MColumn.get((Properties)tab.getCtx(), (int)tab.getAD_Column_ID());
            detail.put("link_column_name", column2.getColumnName());
            if (!contextColumnsList.contains(column2.getColumnName())) {
                contextColumnsList.add(column2.getColumnName());
            }
        }
        if (tab.getTabLevel() > 0) {
            for (MColumn column3 : table.getColumns(false)) {
                if (!column3.isParent() || contextColumnsList.contains(column3.getColumnName())) continue;
                contextColumnsList.add(column3.getColumnName());
            }
        }
        detail.put("context_column_names", contextColumnsList);
        detail.put("is_sort_tab", tab.isSortTab());
        if (tab.isSortTab()) {
            if (tab.getAD_ColumnSortOrder_ID() > 0) {
                column2 = MColumn.get((Properties)tab.getCtx(), (int)tab.getAD_ColumnSortOrder_ID());
                detail.put("sort_order_column_name", column2.getColumnName());
            }
            if (tab.getAD_ColumnSortYesNo_ID() > 0) {
                column2 = MColumn.get((Properties)tab.getCtx(), (int)tab.getAD_ColumnSortYesNo_ID());
                detail.put("sort_yes_no_column_name", column2.getColumnName());
            }
        }
        detail.put("window_id", tab.getAD_Window_ID());
        detail.put("process_id", tab.getAD_Process_ID());
        if (tab.getAD_Process_ID() > 0 && (process = MProcess.get((Properties)tab.getCtx(), (int)tab.getAD_Process_ID())).isActive()) {
            Map<String, Object> referenceDetail = this.parseProcess(process);
            detail.put("process", referenceDetail);
        }
        detail.put("processes", this.convertProcesses(this.getProcessFromTab(tab)));
        List<MField> fields = Arrays.asList(tab.getFields(false, null));
        detail.put("fields", this.convertFields(fields));
        return detail;
    }

    private List<MProcess> getProcessFromTab(MTab tab) {
        String whereClause = "IsActive = 'Y' AND (AD_Process_ID = ? OR EXISTS(SELECT 1 FROM AD_Field f INNER JOIN AD_Column c ON(c.AD_Column_ID = f.AD_Column_ID) WHERE c.AD_Process_ID = AD_Process.AD_Process_ID AND f.IsDisplayed = 'Y' AND f.AD_Tab_ID = ? AND f.IsActive = 'Y') OR EXISTS(SELECT 1 FROM AD_Table_Process AS tp WHERE tp.AD_Process_ID = AD_Process.AD_Process_ID AND tp.AD_Table_ID = ? AND tp.IsActive = 'Y'))";
        ArrayList<Integer> filterList = new ArrayList<Integer>();
        filterList.add(tab.getAD_Process_ID());
        filterList.add(tab.getAD_Tab_ID());
        filterList.add(tab.getAD_Table_ID());
        return new Query(tab.getCtx(), "AD_Process", "IsActive = 'Y' AND (AD_Process_ID = ? OR EXISTS(SELECT 1 FROM AD_Field f INNER JOIN AD_Column c ON(c.AD_Column_ID = f.AD_Column_ID) WHERE c.AD_Process_ID = AD_Process.AD_Process_ID AND f.IsDisplayed = 'Y' AND f.AD_Tab_ID = ? AND f.IsActive = 'Y') OR EXISTS(SELECT 1 FROM AD_Table_Process AS tp WHERE tp.AD_Process_ID = AD_Process.AD_Process_ID AND tp.AD_Table_ID = ? AND tp.IsActive = 'Y'))", null).setParameters(filterList).list();
    }

    private List<Map<String, Object>> convertFields(List<MField> fields) {
        ArrayList<Map<String, Object>> fieldsDetail = new ArrayList<Map<String, Object>>();
        if (fields == null) {
            return fieldsDetail;
        }
        fields.forEach(field -> fieldsDetail.add(this.parseField((MField)field)));
        return fieldsDetail;
    }

    private List<Map<String, Object>> convertProcesses(List<MProcess> processesList) {
        ArrayList<Map<String, Object>> processesDetail = new ArrayList<Map<String, Object>>();
        if (processesList == null || processesList.isEmpty()) {
            return processesDetail;
        }
        processesList.parallelStream().forEach(process -> processesDetail.add(this.parseProcess((MProcess)process)));
        return processesDetail;
    }

    private Map<String, Object> parseProcess(MProcess process) {
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("id", process.getAD_Process_ID());
        detail.put("uuid", process.getUUID());
        detail.put("name", process.get_Translation("Name", this.getLanguage()));
        detail.put("description", process.get_Translation("Description", this.getLanguage()));
        detail.put("help", process.get_Translation("Help", this.getLanguage()));
        detail.put("is_report", process.isReport());
        detail.put("browser_id", process.getAD_Browse_ID());
        detail.put("form_id", process.getAD_Form_ID());
        detail.put("workflow_id", process.getAD_Workflow_ID());
        if (process.getAD_Browse_ID() > 0) {
            MBrowse browse = MBrowse.get((Properties)process.getCtx(), (int)process.getAD_Browse_ID());
            detail.put("browser", this.parseDictionaryEntity((PO)browse));
        } else if (process.getAD_Form_ID() > 0) {
            MForm form = new MForm(process.getCtx(), process.getAD_Form_ID(), null);
            detail.put("form", this.parseDictionaryEntity((PO)form));
        } else if (process.getAD_Workflow_ID() > 0) {
            MWorkflow workflow = MWorkflow.get((Properties)process.getCtx(), (int)process.getAD_Workflow_ID());
            detail.put("workflow", this.parseDictionaryEntity((PO)workflow));
        }
        return detail;
    }

    private Map<String, Object> parseField(MField field) {
        ReferenceValues referenceValues;
        int validationRuleId;
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("id", field.getAD_Field_ID());
        detail.put("uuid", field.getUUID());
        detail.put("name", field.get_Translation("Name", this.getLanguage()));
        detail.put("description", field.get_Translation("Description", this.getLanguage()));
        detail.put("help", field.get_Translation("Help", this.getLanguage()));
        detail.put("is_active", field.isActive());
        detail.put("is_allow_copy", field.isAllowCopy());
        detail.put("is_heading", field.isHeading());
        detail.put("is_field_only", field.isFieldOnly());
        MColumn column = MColumn.get((Properties)field.getCtx(), (int)field.getAD_Column_ID());
        detail.put("column_name", column.getColumnName());
        detail.put("column_sql", column.getColumnSQL());
        detail.put("is_key", column.isKey());
        detail.put("is_parent", column.isParent());
        detail.put("is_translated", column.isTranslated());
        detail.put("is_identifier", column.isIdentifier());
        detail.put("identifier_sequence", column.getSeqNo());
        detail.put("is_selection_column", column.isSelectionColumn());
        detail.put("callout", column.getCallout());
        int displayTypeId = field.getAD_Reference_ID();
        if (displayTypeId <= 0) {
            displayTypeId = column.getAD_Reference_ID();
        }
        detail.put("display_type", displayTypeId);
        detail.put("default_value", Optional.ofNullable(field.getDefaultValue()).orElse(column.getDefaultValue()));
        detail.put("field_length", column.getFieldLength());
        detail.put("v_format", column.getVFormat());
        detail.put("format_pattern", column.getFormatPattern());
        detail.put("value_min", column.getValueMin());
        detail.put("value_max", column.getValueMax());
        detail.put("is_encrypted", field.isEncrypted());
        detail.put("is_displayed", field.isDisplayed());
        detail.put("display_logic", field.getDisplayLogic());
        detail.put("sequence", field.getSeqNo());
        detail.put("is_displayed_grid", field.isDisplayedGrid());
        detail.put("grid_sequence", field.getSeqNoGrid());
        detail.put("is_displayed_as_panel", field.isActive() && field.isDisplayed() ? "Y" : "N");
        detail.put("is_displayed_as_table", Character.valueOf((char)(field.isActive() && field.isDisplayedGrid() ? 89 : 78)));
        detail.put("is_read_only", field.isReadOnly());
        detail.put("read_only_logic", column.getReadOnlyLogic());
        detail.put("is_updateable", column.isUpdateable());
        detail.put("is_always_updateable", column.isAlwaysUpdateable());
        detail.put("is_mandatory", field.getIsMandatory() != null && field.getIsMandatory().equals("Y") ? true : column.isMandatory());
        detail.put("mandatory_logic", column.getMandatoryLogic());
        int referenceValueId = field.getAD_Reference_Value_ID();
        if (referenceValueId <= 0) {
            referenceValueId = column.getAD_Reference_Value_ID();
        }
        if ((validationRuleId = field.getAD_Val_Rule_ID()) <= 0) {
            validationRuleId = column.getAD_Val_Rule_ID();
        }
        if ((referenceValues = ReferenceUtil.getReferenceDefinition(column.getColumnName(), displayTypeId, referenceValueId, validationRuleId)) != null) {
            HashMap<String, Object> referenceDetail = new HashMap<String, Object>();
            referenceDetail.put("table_name", referenceValues.getTableName());
            referenceDetail.put("context_column_names", ReferenceUtil.getContextColumnNames(referenceValues.getEmbeddedContextColumn()));
            detail.put("reference", referenceDetail);
        }
        detail.put("context_column_names", ReferenceUtil.getContextColumnNames(Optional.ofNullable(field.getDefaultValue()).orElse(column.getDefaultValue())));
        detail.put("dependent_fields", DependenceUtil.generateDependentWindowFields(field));
        detail.put("process_id", column.getAD_Process_ID());
        if (column.getAD_Process_ID() > 0) {
            detail.put("process", this.parseProcess(MProcess.get((Properties)field.getCtx(), (int)column.getAD_Process_ID())));
        }
        return detail;
    }

    private Window() {
    }

    public static Window newInstance() {
        return new Window();
    }

    @Override
    public String getChannel() {
        return CHANNEL;
    }
}

