/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca56.util.support.kafka;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.eca56.util.KafkaLoader;
import org.spin.eca56.util.support.IGenericDocument;
import org.spin.eca56.util.support.IGenericSender;
import org.spin.eca56.util.support.kafka.TestDocument;
import org.spin.model.MADAppRegistration;

public class Sender
implements IGenericSender {
    private CLogger log = CLogger.getCLogger(Sender.class);
    private String host = null;
    private int port;
    private String defaultQueueName = null;
    private int registrationId = 0;

    private void validate() {
        if (this.getAppRegistrationId() <= 0) {
            throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
        }
        MADAppRegistration registration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getAppRegistrationId(), null);
        this.defaultQueueName = registration.getValue().replaceAll("[^a-zA-Z0-9 -]", "").toLowerCase().trim();
        this.port = registration.getPort();
        this.host = registration.getHost();
    }

    public String testConnection() {
        TestDocument defaultTestDocument = TestDocument.newInstance();
        this.send(defaultTestDocument, this.defaultQueueName);
        return defaultTestDocument.getValues().toString();
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        this.validate();
    }

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    @Override
    public void send(IGenericDocument document, String channel) {
        String topicName = channel;
        if (Util.isEmpty((String)topicName)) {
            topicName = this.defaultQueueName;
        }
        if (Util.isEmpty((String)document.getKey())) {
            throw new AdempiereException("@Key@ @NotFound@");
        }
        this.log.fine("Command to Send: " + document);
        try {
            KafkaProducer<String, Object> producer = KafkaLoader.getInstance().getProducer(this.host + ":" + this.port, topicName);
            ProducerRecord record = new ProducerRecord(topicName, (Object)document.getKey(), document.getValues());
            producer.send(record);
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }
}

