/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.db.orm;

import io.github.adiitgg.vertx.db.orm.DaoManager;
import io.github.adiitgg.vertx.db.orm.PgManager;
import io.github.adiitgg.vertx.db.orm.Repository;
import io.github.adiitgg.vertx.db.orm.TransactionRepository;
import io.github.adiitgg.vertx.db.orm.impl.PgRepositoryImpl;
import io.github.adiitgg.vertx.db.orm.model.PgRepositoryOptions;
import io.github.adiitgg.vertx.db.orm.model.TransactionOptions;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.VertxInternal;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.PoolBase;
import io.vertx.sqlclient.impl.SqlClientInternal;
import java.lang.reflect.Field;
import java.util.ServiceConfigurationError;
import java.util.function.Consumer;
import java.util.function.Function;

public interface PgRepository
extends Pool,
SqlClientInternal,
Repository {
    public static Pool create(SqlConnectOptions connectOptions) {
        return PgRepository.create(connectOptions, new PoolOptions());
    }

    public static Pool create(SqlConnectOptions database, PoolOptions options) {
        return PgRepository.create(null, database, options);
    }

    public static PgRepository create(Vertx vertx, SqlConnectOptions database) {
        Pool pool = Pool.pool((Vertx)vertx, (SqlConnectOptions)database, (PoolOptions)new PoolOptions());
        PgRepositoryOptions pgRepositoryOptions = PgRepositoryOptions.newBuilder().pool(pool).build();
        return PgRepository.create(pgRepositoryOptions);
    }

    public static PgRepository create(Vertx vertx, SqlConnectOptions database, PoolOptions options) {
        Pool pool = Pool.pool((Vertx)vertx, (SqlConnectOptions)database, (PoolOptions)options);
        PgRepositoryOptions pgRepositoryOptions = PgRepositoryOptions.newBuilder().pool(pool).build();
        return PgRepository.create(pgRepositoryOptions);
    }

    public static PgRepository create(PgRepositoryOptions pgRepositoryOptions) {
        Pool pool = pgRepositoryOptions.pool();
        if (pool == null) {
            throw new IllegalArgumentException("Pool cannot be null");
        }
        Class<PoolBase> poolBaseClass = PoolBase.class;
        Field vertxField = poolBaseClass.getDeclaredField("vertx");
        if (!vertxField.trySetAccessible()) {
            throw new ServiceConfigurationError("Cannot access vertx field");
        }
        Field closeFutureField = poolBaseClass.getDeclaredField("closeFuture");
        if (!closeFutureField.trySetAccessible()) {
            throw new ServiceConfigurationError("Cannot access close future field");
        }
        Field delegateField = poolBaseClass.getDeclaredField("delegate");
        if (!delegateField.trySetAccessible()) {
            throw new ServiceConfigurationError("Cannot access delegate field");
        }
        VertxInternal vertx = (VertxInternal)vertxField.get(pool);
        CloseFuture closeFuture = (CloseFuture)closeFutureField.get(pool);
        Pool delegate = (Pool)delegateField.get(pool);
        DaoManager daoManager = DaoManager.getInstance();
        PgManager pgManager = PgManager.getInstance();
        if (pgRepositoryOptions.enableModule()) {
            pgManager.findAndLoadModules(null);
        }
        return new PgRepositoryImpl(pgRepositoryOptions, vertx, closeFuture, delegate, daoManager, pgManager);
    }

    public Future<Void> checkConnection();

    public <T> Future<T> transaction(Function<TransactionRepository, Future<T>> var1);

    public <T> Future<T> transaction(TransactionOptions var1, Function<TransactionRepository, Future<T>> var2);

    default public Future<Void> transaction(Consumer<TransactionRepository> block) {
        Function action = repository -> {
            try {
                block.accept((TransactionRepository)repository);
            }
            catch (Throwable e) {
                return Future.failedFuture((Throwable)e);
            }
            return Future.succeededFuture();
        };
        return this.transaction(action);
    }

    default public Future<Void> withTransaction(Consumer<SqlConnection> block) {
        return super.withTransaction(t -> {
            try {
                block.accept((SqlConnection)t);
            }
            catch (Throwable e) {
                return Future.failedFuture((Throwable)e);
            }
            return Future.succeededFuture();
        });
    }
}

