/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.db.orm.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.adiitgg.vertx.db.orm.DaoManager;
import io.github.adiitgg.vertx.db.orm.impl.AnnotationPersistence;
import io.github.adiitgg.vertx.db.orm.model.DAOQueryType;
import io.github.adiitgg.vertx.db.orm.model.EntityFieldOptions;
import io.github.adiitgg.vertx.db.orm.model.EntityOptions;
import io.github.adiitgg.vertx.db.orm.model.FieldWrapper;
import io.github.adiitgg.vertx.db.orm.model.PreparedQuery;
import io.github.adiitgg.vertx.db.orm.model.QueryPreparer;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class DaoManagerImpl
implements DaoManager {
    private final Map<Class<?>, EntityOptions> entityOptions = new HashMap();
    private final Map<String, QueryPreparer> queries = new HashMap<String, QueryPreparer>();
    private final AnnotationPersistence annotationPersistence = new AnnotationPersistence();
    private final ObjectMapper objectMapper = DatabindCodec.mapper();

    public static DaoManagerImpl getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void scanEntityPackage(String packageName) {
        InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(packageName.replaceAll("[.]", "/"));
        if (stream == null) {
            throw new IllegalArgumentException("Package not found: " + packageName);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.lines().filter(line -> line.endsWith(".class")).map(line -> this.getClass((String)line, packageName)).filter(Objects::nonNull).forEach(this::prepare);
    }

    private Class<?> getClass(String className, String packageName) {
        try {
            return Class.forName(packageName + "." + className.substring(0, className.lastIndexOf(46)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityOptions getEntityOptions(Class<?> clazz) {
        EntityOptions options = this.entityOptions.get(clazz);
        if (options == null) {
            Map<Class<?>, EntityOptions> map = this.entityOptions;
            synchronized (map) {
                options = this.entityOptions.get(clazz);
            }
        }
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEntityOptions(Class<?> clazz, EntityOptions options) {
        Map<Class<?>, EntityOptions> map = this.entityOptions;
        synchronized (map) {
            this.entityOptions.put(clazz, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryPreparer getQuery(String key) {
        QueryPreparer query = this.queries.get(key);
        if (query == null) {
            Map<String, QueryPreparer> map = this.queries;
            synchronized (map) {
                query = this.queries.get(key);
            }
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQuery(String key, QueryPreparer value) {
        Map<String, QueryPreparer> map = this.queries;
        synchronized (map) {
            this.queries.put(key, value);
        }
    }

    private EntityOptions loadClass(Class<?> clazz) {
        EntityOptions currentOptions = this.getEntityOptions(clazz);
        if (currentOptions != null) {
            return currentOptions;
        }
        EntityOptions options = new EntityOptions().entityClass(clazz).constructor(Arrays.stream(clazz.getDeclaredConstructors()).filter(c -> c.getParameterCount() == 0).findFirst().orElse(null));
        String entityName = this.annotationPersistence.getEntityName(clazz);
        options.tableName(entityName);
        List<EntityFieldOptions> fieldOptionsList = Arrays.stream(clazz.getDeclaredFields()).map(this.annotationPersistence::createEntityFieldOptions).toList();
        options.entityFieldOptions(fieldOptionsList);
        this.setEntityOptions(clazz, options);
        return options;
    }

    @Override
    public void prepare(Class<?> entityClass) {
        for (DAOQueryType value : DAOQueryType.VALUES) {
            this.prepare(entityClass, value, null);
        }
    }

    @Override
    public QueryPreparer prepare(Class<?> entityClass, DAOQueryType queryType, List<EntityFieldOptions> updateColumns) {
        QueryPreparer current;
        if (entityClass == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        StringBuilder key = new StringBuilder(entityClass.getSimpleName() + "-" + queryType.name());
        if (updateColumns != null && !updateColumns.isEmpty()) {
            key.append("-");
            for (EntityFieldOptions updateColumn : updateColumns) {
                key.append(updateColumn.columnName());
            }
        }
        if ((current = this.getQuery(key.toString())) != null) {
            return current;
        }
        QueryPreparer queryPreparer = switch (queryType) {
            default -> throw new MatchException(null, null);
            case DAOQueryType.INSERT -> this.prepareInsertSQL(entityClass);
            case DAOQueryType.UPDATE -> this.prepareUpdateSQL(entityClass, updateColumns != null && !updateColumns.isEmpty() ? updateColumns : null);
            case DAOQueryType.UPSERT -> this.prepareUpsertSQL(entityClass);
        };
        this.setQuery(key.toString(), queryPreparer);
        return queryPreparer;
    }

    private QueryPreparer prepareInsertSQL(Class<?> clazz) {
        EntityOptions options = this.loadClass(clazz);
        String tableName = options.tableName();
        ArrayList<EntityFieldOptions> params = new ArrayList<EntityFieldOptions>();
        StringBuilder query = new StringBuilder("INSERT INTO ");
        query.append(tableName).append(" (");
        List<EntityFieldOptions> insertableColumns = options.entityFieldOptions().stream().filter(fieldOptions -> !fieldOptions.autoGeneratedId() && fieldOptions.insertable()).toList();
        String columns = insertableColumns.stream().map(EntityFieldOptions::columnName).collect(Collectors.joining(", "));
        query.append(columns).append(") VALUES (");
        for (int i = 0; i < insertableColumns.size(); ++i) {
            query.append("$").append(i + 1).append(", ");
            params.add(insertableColumns.get(i));
        }
        query.setLength(query.length() - 2);
        query.append(")");
        List<FieldWrapper> updateFields = options.entityFieldOptions().stream().filter(EntityFieldOptions::updateable).map(EntityFieldOptions::fieldWrapper).toList();
        return new QueryPreparer().sql(query.toString()).fieldOptions(params).fieldWrappers(updateFields);
    }

    private QueryPreparer prepareUpsertSQL(Class<?> clazz) {
        EntityOptions options = this.loadClass(clazz);
        String tableName = options.tableName();
        ArrayList<EntityFieldOptions> params = new ArrayList<EntityFieldOptions>();
        StringBuilder query = new StringBuilder("INSERT INTO ");
        query.append(tableName).append(" (");
        List<EntityFieldOptions> insertableColumns = options.entityFieldOptions().stream().filter(fieldOptions -> !fieldOptions.autoGeneratedId() && fieldOptions.insertable() || fieldOptions.canConflict()).toList();
        String columns = insertableColumns.stream().map(EntityFieldOptions::columnName).collect(Collectors.joining(", "));
        query.append(columns).append(") VALUES (");
        for (int i = 0; i < insertableColumns.size(); ++i) {
            query.append("$").append(i + 1).append(", ");
            params.add(insertableColumns.get(i));
        }
        query.setLength(query.length() - 2);
        query.append(") ON CONFLICT (");
        List<EntityFieldOptions> canConflictColumns = options.entityFieldOptions().stream().filter(EntityFieldOptions::canConflict).toList();
        List<EntityFieldOptions> conflictColumns = canConflictColumns.isEmpty() ? options.entityFieldOptions().stream().filter(EntityFieldOptions::id).toList() : canConflictColumns;
        QueryPreparer queryPreparer = new QueryPreparer();
        conflictColumns.forEach(fieldOptions -> query.append(fieldOptions.columnName()).append(", "));
        if (!conflictColumns.isEmpty()) {
            query.setLength(query.length() - 2);
            query.append(")");
            query.append(" DO UPDATE SET ");
            List<EntityFieldOptions> updateableColumns = options.entityFieldOptions().stream().filter(fieldOptions -> !fieldOptions.autoGeneratedId() && !fieldOptions.isCreatedAt() && fieldOptions.updateable() && conflictColumns.stream().noneMatch(f -> f.columnName().equals(fieldOptions.columnName()))).toList();
            updateableColumns.forEach(fieldOptions -> query.append(fieldOptions.columnName()).append(" = EXCLUDED.").append(fieldOptions.columnName()).append(", "));
            if (!updateableColumns.isEmpty()) {
                query.setLength(query.length() - 2);
            }
            List<FieldWrapper> updateFields = options.entityFieldOptions().stream().filter(EntityFieldOptions::updateable).map(EntityFieldOptions::fieldWrapper).toList();
            queryPreparer.fieldWrappers(updateFields);
        } else {
            query.setLength(query.length() - 2);
            query.append(" DO NOTHING");
            queryPreparer.fieldWrappers(Collections.emptyList());
        }
        return queryPreparer.sql(query.toString()).fieldOptions(params);
    }

    private QueryPreparer prepareUpdateSQL(Class<?> clazz, List<EntityFieldOptions> updateColumns) {
        EntityOptions options = this.loadClass(clazz);
        String tableName = options.tableName();
        ArrayList<EntityFieldOptions> params = new ArrayList<EntityFieldOptions>();
        StringBuilder query = new StringBuilder("UPDATE ").append(tableName).append(" SET ");
        List<EntityFieldOptions> whereColumns = options.entityFieldOptions().stream().filter(EntityFieldOptions::id).toList();
        ArrayList<EntityFieldOptions> updateableColumns = new ArrayList<EntityFieldOptions>();
        if (updateColumns != null) {
            updateCols = updateColumns.stream().filter(fieldOptions -> fieldOptions.isUpdatedAt() || fieldOptions.updateable() && whereColumns.stream().noneMatch(f -> f.columnName().equals(fieldOptions.columnName()))).toList();
            updateableColumns.addAll((Collection<EntityFieldOptions>)updateCols);
            List<EntityFieldOptions> updatedFields = options.entityFieldOptions().stream().filter(fieldOptions -> fieldOptions.isUpdatedAt() && updateCols.stream().noneMatch(fo -> fo.columnName().equals(fieldOptions.columnName()))).toList();
            updateableColumns.addAll(updatedFields);
        } else {
            updateCols = options.entityFieldOptions().stream().filter(fieldOptions -> fieldOptions.isUpdatedAt() || !fieldOptions.autoGeneratedId() && fieldOptions.updateable() && whereColumns.stream().noneMatch(f -> f.columnName().equals(fieldOptions.columnName()))).toList();
            updateableColumns.addAll((Collection<EntityFieldOptions>)updateCols);
        }
        for (EntityFieldOptions fieldOption : updateableColumns) {
            query.append(fieldOption.columnName()).append(" = $").append(updateableColumns.indexOf(fieldOption) + 1).append(", ");
            params.add(fieldOption);
        }
        query.setLength(query.length() - 2);
        query.append(" WHERE ");
        whereColumns.forEach(f -> {
            query.append(f.columnName()).append(" = $").append(updateableColumns.size() + whereColumns.indexOf(f) + 1).append(" AND ");
            params.add((EntityFieldOptions)f);
        });
        query.setLength(query.length() - 4);
        List<FieldWrapper> updateFields = options.entityFieldOptions().stream().filter(EntityFieldOptions::updateable).map(EntityFieldOptions::fieldWrapper).toList();
        return new QueryPreparer().sql(query.toString()).fieldOptions(params).fieldWrappers(updateFields);
    }

    @Override
    public PreparedQuery getPreparedQueryEntity(Object entity, DAOQueryType queryType, boolean returning) {
        return this.getPreparedQueryEntity(entity, queryType, null, returning);
    }

    @Override
    public PreparedQuery getPreparedQueryEntity(Object entity, DAOQueryType queryType, List<EntityFieldOptions> updateColumns, boolean returning) {
        QueryPreparer queryPreparer = this.prepare(entity.getClass(), queryType, updateColumns);
        Object[] params = queryPreparer.fieldOptions().stream().map(f -> {
            boolean isInsert;
            Object result = f.fieldWrapper().getter().apply(entity);
            boolean bl = isInsert = queryType == DAOQueryType.INSERT || queryType == DAOQueryType.UPSERT;
            if (isInsert && result == null && (f.isCreatedAt() || f.isUpdatedAt())) {
                return f.defaultValueProvider().get();
            }
            if (f.isUpdatedAt()) {
                return f.defaultValueProvider().get();
            }
            if (f.serialized() != null) {
                return this.objectMapper.convertValue(result, f.serialized());
            }
            return result;
        }).toArray();
        return new PreparedQuery().sql(queryPreparer.sql() + (returning ? " RETURNING *" : "")).tuple(Tuple.wrap((Object[])params)).queryPreparer(queryPreparer);
    }

    @Override
    public <T> T updateEntityFromRow(PreparedQuery preparedQuery, T entity, Row row) {
        if (entity == null) {
            return null;
        }
        for (FieldWrapper fieldWrapper : preparedQuery.queryPreparer().fieldWrappers()) {
            fieldWrapper.setter().accept(entity, row.getValue(fieldWrapper.columnName()));
        }
        return entity;
    }

    private static class Holder {
        private static final DaoManagerImpl INSTANCE = new DaoManagerImpl();

        private Holder() {
        }
    }
}

