/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.db.orm.impl;

import io.github.adiitgg.vertx.db.orm.PgManager;
import io.github.adiitgg.vertx.db.orm.PgModule;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public class PgManagerImpl
implements PgManager {
    private List<PgModule> loadedModules;

    public static PgManagerImpl getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void findAndLoadModules(ClassLoader classLoader) {
        this.loadedModules = this.findModules(classLoader);
    }

    @Override
    public List<PgModule> findModules(ClassLoader classLoader) {
        ArrayList<PgModule> modules = new ArrayList<PgModule>();
        ServiceLoader<PgModule> loader = this.secureGetServiceLoader(PgModule.class, classLoader);
        for (PgModule module : loader) {
            modules.add(module);
        }
        return modules;
    }

    @Override
    public List<PgModule> getLoadedModules() {
        return this.loadedModules;
    }

    private <T> ServiceLoader<T> secureGetServiceLoader(Class<T> clazz, ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return classLoader == null ? ServiceLoader.load(clazz) : ServiceLoader.load(clazz, classLoader);
        }
        return AccessController.doPrivileged(() -> classLoader == null ? ServiceLoader.load(clazz) : ServiceLoader.load(clazz, classLoader));
    }

    private static class Holder {
        private static final PgManagerImpl INSTANCE = new PgManagerImpl();

        private Holder() {
        }
    }
}

