/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.db.orm.impl;

import io.github.adiitgg.vertx.db.orm.DaoManager;
import io.github.adiitgg.vertx.db.orm.PgManager;
import io.github.adiitgg.vertx.db.orm.PgRepository;
import io.github.adiitgg.vertx.db.orm.PreparedQueryFilter;
import io.github.adiitgg.vertx.db.orm.TransactionRepository;
import io.github.adiitgg.vertx.db.orm.impl.TransactionRepositoryImpl;
import io.github.adiitgg.vertx.db.orm.model.DAOQueryType;
import io.github.adiitgg.vertx.db.orm.model.EntityFieldOptions;
import io.github.adiitgg.vertx.db.orm.model.PgRepositoryOptions;
import io.github.adiitgg.vertx.db.orm.model.TransactionOptions;
import io.github.adiitgg.vertx.db.orm.model.diff.DiffSnapshot;
import io.github.adiitgg.vertx.db.orm.util.DiffUtil;
import io.github.adiitgg.vertx.db.orm.util.RepositoryUtil;
import io.github.adiitgg.vertx.db.orm.util.RowUtil;
import io.vertx.core.Future;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.TransactionRollbackException;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.PoolBase;
import io.vertx.sqlclient.impl.PoolImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class PgRepositoryImpl
extends PoolBase<PoolImpl>
implements PgRepository {
    private static final Logger log = LoggerFactory.getLogger(PgRepository.class);
    private final PgRepositoryOptions pgRepositoryOptions;
    private final DaoManager daoManager;
    private List<PreparedQueryFilter> preparedQueryFilters;

    public PgRepositoryImpl(PgRepositoryOptions pgRepositoryOptions, VertxInternal vertx, CloseFuture closeFuture, Pool delegate, DaoManager daoManager, PgManager pgManager) {
        super(vertx, closeFuture, delegate);
        this.pgRepositoryOptions = pgRepositoryOptions;
        this.daoManager = daoManager;
        this.preparedQueryFilters = pgManager.getLoadedModules().stream().map(module -> {
            PreparedQueryFilter m;
            return module instanceof PreparedQueryFilter ? (m = (PreparedQueryFilter)module) : null;
        }).filter(Objects::nonNull).toList();
        if (this.preparedQueryFilters.isEmpty()) {
            this.preparedQueryFilters = null;
        }
    }

    private <T> Future<Row> executePreparedQuery(T entity, DAOQueryType queryType, boolean returning) {
        io.github.adiitgg.vertx.db.orm.model.PreparedQuery preparedQuery = this.daoManager.getPreparedQueryEntity(entity, queryType, returning);
        if (this.pgRepositoryOptions.debug()) {
            RepositoryUtil.logQueryEntity(log, preparedQuery);
        }
        long startTime = System.currentTimeMillis();
        return this.preparedQuery(preparedQuery.sql()).execute(preparedQuery.tuple()).onComplete(RepositoryUtil.logQuery(log, this.pgRepositoryOptions.maxQueryTookTime(), startTime, preparedQuery.sql())).map(RowUtil::firstOrNull);
    }

    private <T> Future<T> executeAndUpdatePreparedQuery(T entity, DAOQueryType queryType, boolean updateCurrentEntity) {
        io.github.adiitgg.vertx.db.orm.model.PreparedQuery preparedQuery = this.daoManager.getPreparedQueryEntity(entity, queryType, updateCurrentEntity);
        if (this.pgRepositoryOptions.debug()) {
            RepositoryUtil.logQueryEntity(log, preparedQuery);
        }
        long startTime = System.currentTimeMillis();
        return this.preparedQuery(preparedQuery.sql()).execute(preparedQuery.tuple()).onComplete(RepositoryUtil.logQuery(log, this.pgRepositoryOptions.maxQueryTookTime(), startTime, preparedQuery.sql())).map(rows -> {
            if (updateCurrentEntity) {
                return this.daoManager.updateEntityFromRow(preparedQuery, entity, RowUtil.firstOrNull((Iterable<Row>)rows));
            }
            return entity;
        });
    }

    private <T> Future<Row> executeBatchPreparedQuery(List<T> entityList, DAOQueryType queryType, boolean returning) {
        if (entityList.isEmpty()) {
            throw new IllegalArgumentException("entityList must not be empty");
        }
        io.github.adiitgg.vertx.db.orm.model.PreparedQuery preparedQuery = null;
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (T entity : entityList) {
            io.github.adiitgg.vertx.db.orm.model.PreparedQuery pQuery = this.daoManager.getPreparedQueryEntity(entity, queryType, returning);
            if (preparedQuery == null) {
                preparedQuery = pQuery;
            }
            tuples.add(pQuery.tuple());
        }
        if (this.pgRepositoryOptions.debug()) {
            RepositoryUtil.logQueryEntity(log, preparedQuery);
        }
        long startTime = System.currentTimeMillis();
        return this.preparedQuery(preparedQuery.sql()).executeBatch(tuples).onComplete(RepositoryUtil.logQuery(log, this.pgRepositoryOptions.maxQueryTookTime(), startTime, preparedQuery.sql())).map(RowUtil::firstOrNull);
    }

    @Override
    public <T> Future<Row> insert(T entity, boolean returning) {
        return this.executePreparedQuery(entity, DAOQueryType.INSERT, returning);
    }

    @Override
    public <T> Future<T> insertEntity(T entity, boolean updateCurrentEntity) {
        return this.executeAndUpdatePreparedQuery(entity, DAOQueryType.INSERT, updateCurrentEntity);
    }

    @Override
    public <T> Future<Row> insertBatch(List<T> entityList, boolean returning) {
        return this.executeBatchPreparedQuery(entityList, DAOQueryType.INSERT, returning);
    }

    @Override
    public <T> Future<Row> upsert(T entity, boolean returning) {
        return this.executePreparedQuery(entity, DAOQueryType.UPSERT, returning);
    }

    @Override
    public <T> Future<T> upsertEntity(T entity, boolean updateCurrentEntity) {
        return this.executeAndUpdatePreparedQuery(entity, DAOQueryType.UPSERT, updateCurrentEntity);
    }

    @Override
    public <T> Future<Row> upsertBatch(List<T> entityList, boolean returning) {
        return this.executeBatchPreparedQuery(entityList, DAOQueryType.UPSERT, returning);
    }

    @Override
    public <T> Future<Row> update(T entity, boolean returning) {
        return this.executePreparedQuery(entity, DAOQueryType.UPDATE, returning);
    }

    @Override
    public <T> Future<T> updateEntity(T entity, boolean updateCurrentEntity) {
        return this.executeAndUpdatePreparedQuery(entity, DAOQueryType.UPDATE, updateCurrentEntity);
    }

    @Override
    public <T> Future<Row> update(T entity, Consumer<T> block) {
        DiffSnapshot commit = DiffUtil.snapshot(entity);
        block.accept(entity);
        List<EntityFieldOptions> diffProperty = DiffUtil.diff(commit, entity);
        io.github.adiitgg.vertx.db.orm.model.PreparedQuery preparedQuery = this.daoManager.getPreparedQueryEntity(entity, DAOQueryType.UPDATE, diffProperty, false);
        Tuple tuple = preparedQuery.tuple();
        if (this.pgRepositoryOptions.debug()) {
            RepositoryUtil.logQueryEntity(log, preparedQuery);
        }
        long startTime = System.currentTimeMillis();
        return this.preparedQuery(preparedQuery.sql()).execute(tuple).onComplete(RepositoryUtil.logQuery(log, this.pgRepositoryOptions.maxQueryTookTime(), startTime, preparedQuery.sql())).map(RowUtil::firstOrNull);
    }

    private Future<Void> loadConfigTransaction(TransactionOptions options, SqlConnection connection) {
        if (options.statementTimeout() == null) {
            return Future.succeededFuture();
        }
        return connection.preparedQuery("SET LOCAL statement_timeout = '" + options.statementTimeout() + "'").execute().mapEmpty();
    }

    @Override
    public Future<Void> checkConnection() {
        return this.preparedQuery("SELECT 'ok' as ok").execute().map(rows -> {
            boolean succeed;
            boolean bl = succeed = rows.size() == 1;
            if (!succeed) {
                throw new IllegalArgumentException("Connection failed");
            }
            return null;
        });
    }

    @Override
    public <T> Future<T> transaction(Function<TransactionRepository, Future<T>> block) {
        TransactionOptions options = TransactionOptions.newBuilder().maxQueryTookTime(this.pgRepositoryOptions.maxQueryTookTime()).build();
        return this.transaction(options, block);
    }

    @Override
    public <T> Future<T> transaction(TransactionOptions options, Function<TransactionRepository, Future<T>> block) {
        return this.getConnection().flatMap(conn -> conn.begin().flatMap(tx -> this.loadConfigTransaction(options, (SqlConnection)conn).map(u -> tx)).flatMap(tx -> {
            TransactionRepositoryImpl repo = new TransactionRepositoryImpl(options, (SqlConnection)conn, (Transaction)tx, this.daoManager, this.preparedQueryFilters);
            try {
                return ((Future)block.apply(repo)).compose(res -> repo.commitTransaction().flatMap(v -> Future.succeededFuture((Object)res)), err -> {
                    if (err instanceof TransactionRollbackException) {
                        return Future.failedFuture((Throwable)err);
                    }
                    return repo.getTransaction() == null ? Future.failedFuture((Throwable)err) : tx.rollback().compose(v -> Future.failedFuture((Throwable)err), failure -> Future.failedFuture((Throwable)err));
                });
            }
            catch (Throwable e) {
                return Future.failedFuture((Throwable)e);
            }
        }).onComplete(ar -> conn.close()));
    }

    public PreparedQuery<RowSet<Row>> preparedQuery(String sql) {
        if (this.pgRepositoryOptions.enableModule() && this.preparedQueryFilters != null) {
            for (PreparedQueryFilter filter : this.preparedQueryFilters) {
                sql = filter.filter(sql, null);
            }
        }
        return super.preparedQuery(sql);
    }

    public PreparedQuery<RowSet<Row>> preparedQuery(String sql, PrepareOptions options) {
        if (this.pgRepositoryOptions.enableModule() && this.preparedQueryFilters != null) {
            for (PreparedQueryFilter filter : this.preparedQueryFilters) {
                sql = filter.filter(sql, options);
            }
        }
        return super.preparedQuery(sql, options);
    }
}

