/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.db.orm.impl;

import io.github.adiitgg.vertx.db.orm.DaoManager;
import io.github.adiitgg.vertx.db.orm.PreparedQueryFilter;
import io.github.adiitgg.vertx.db.orm.TransactionRepository;
import io.github.adiitgg.vertx.db.orm.model.DAOQueryType;
import io.github.adiitgg.vertx.db.orm.model.EntityFieldOptions;
import io.github.adiitgg.vertx.db.orm.model.TransactionOptions;
import io.github.adiitgg.vertx.db.orm.model.diff.DiffSnapshot;
import io.github.adiitgg.vertx.db.orm.util.DiffUtil;
import io.github.adiitgg.vertx.db.orm.util.RepositoryUtil;
import io.github.adiitgg.vertx.db.orm.util.RowUtil;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.Query;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;

public class TransactionRepositoryImpl
implements TransactionRepository {
    private static final Logger log = LoggerFactory.getLogger(TransactionRepository.class);
    private final TransactionOptions options;
    private final SqlConnection sqlConnection;
    private final Transaction transaction;
    private final DaoManager daoManager;
    private final List<PreparedQueryFilter> preparedQueryFilters;
    private boolean commited;

    private <T> Future<Row> executePreparedQuery(T entity, DAOQueryType queryType, boolean returning) {
        io.github.adiitgg.vertx.db.orm.model.PreparedQuery preparedQuery = this.daoManager.getPreparedQueryEntity(entity, queryType, returning);
        long startTime = System.currentTimeMillis();
        return this.preparedQuery(preparedQuery.sql()).execute(preparedQuery.tuple()).onComplete(RepositoryUtil.logQuery(log, this.options.maxQueryTookTime(), startTime, preparedQuery.sql())).map(RowUtil::firstOrNull);
    }

    private <T> Future<T> executeAndUpdatePreparedQuery(T entity, DAOQueryType queryType, boolean updateCurrentEntity) {
        io.github.adiitgg.vertx.db.orm.model.PreparedQuery preparedQuery = this.daoManager.getPreparedQueryEntity(entity, queryType, updateCurrentEntity);
        long startTime = System.currentTimeMillis();
        return this.preparedQuery(preparedQuery.sql()).execute(preparedQuery.tuple()).onComplete(RepositoryUtil.logQuery(log, this.options.maxQueryTookTime(), startTime, preparedQuery.sql())).map(rows -> {
            if (updateCurrentEntity) {
                return this.daoManager.updateEntityFromRow(preparedQuery, entity, RowUtil.firstOrNull((Iterable<Row>)rows));
            }
            return entity;
        });
    }

    private <T> Future<Row> executeBatchPreparedQuery(List<T> entityList, DAOQueryType queryType, boolean returning) {
        if (entityList.isEmpty()) {
            throw new IllegalArgumentException("entityList must not be empty");
        }
        io.github.adiitgg.vertx.db.orm.model.PreparedQuery preparedQuery = null;
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (T entity : entityList) {
            io.github.adiitgg.vertx.db.orm.model.PreparedQuery pQuery = this.daoManager.getPreparedQueryEntity(entity, queryType, returning);
            if (preparedQuery == null) {
                preparedQuery = pQuery;
            }
            tuples.add(pQuery.tuple());
        }
        long startTime = System.currentTimeMillis();
        return this.preparedQuery(preparedQuery.sql()).executeBatch(tuples).onComplete(RepositoryUtil.logQuery(log, this.options.maxQueryTookTime(), startTime, preparedQuery.sql())).map(RowUtil::firstOrNull);
    }

    @Override
    public <T> Future<Row> insert(T entity, boolean returning) {
        return this.executePreparedQuery(entity, DAOQueryType.INSERT, returning);
    }

    @Override
    public <T> Future<T> insertEntity(T entity, boolean updateCurrentEntity) {
        return this.executeAndUpdatePreparedQuery(entity, DAOQueryType.INSERT, updateCurrentEntity);
    }

    @Override
    public <T> Future<Row> insertBatch(List<T> entityList, boolean returning) {
        return this.executeBatchPreparedQuery(entityList, DAOQueryType.INSERT, returning);
    }

    @Override
    public <T> Future<Row> upsert(T entity, boolean returning) {
        return this.executePreparedQuery(entity, DAOQueryType.UPSERT, returning);
    }

    @Override
    public <T> Future<T> upsertEntity(T entity, boolean updateCurrentEntity) {
        return this.executeAndUpdatePreparedQuery(entity, DAOQueryType.UPSERT, updateCurrentEntity);
    }

    @Override
    public <T> Future<Row> upsertBatch(List<T> entityList, boolean returning) {
        return this.executeBatchPreparedQuery(entityList, DAOQueryType.UPSERT, returning);
    }

    @Override
    public <T> Future<Row> update(T entity, boolean returning) {
        return this.executePreparedQuery(entity, DAOQueryType.UPDATE, returning);
    }

    @Override
    public <T> Future<T> updateEntity(T entity, boolean updateCurrentEntity) {
        return this.executeAndUpdatePreparedQuery(entity, DAOQueryType.UPDATE, updateCurrentEntity);
    }

    @Override
    public <T> Future<Row> update(T entity, Consumer<T> block) {
        DiffSnapshot commit = DiffUtil.snapshot(entity);
        block.accept(entity);
        List<EntityFieldOptions> diffProperty = DiffUtil.diff(commit, entity);
        io.github.adiitgg.vertx.db.orm.model.PreparedQuery preparedQuery = this.daoManager.getPreparedQueryEntity(entity, DAOQueryType.UPDATE, diffProperty, false);
        Tuple tuple = preparedQuery.tuple();
        return this.preparedQuery(preparedQuery.sql()).execute(tuple).map(RowUtil::firstOrNull);
    }

    @Override
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public Future<Void> commitTransaction() {
        if (this.commited) {
            return Future.succeededFuture();
        }
        this.commited = true;
        return this.transaction.commit().onFailure(e -> {
            this.commited = false;
        });
    }

    public Query<RowSet<Row>> query(String sql) {
        return this.sqlConnection.query(sql);
    }

    public PreparedQuery<RowSet<Row>> preparedQuery(String sql) {
        if (this.preparedQueryFilters != null) {
            for (PreparedQueryFilter filter : this.preparedQueryFilters) {
                sql = filter.filter(sql, null);
            }
        }
        return this.sqlConnection.preparedQuery(sql);
    }

    public PreparedQuery<RowSet<Row>> preparedQuery(String sql, PrepareOptions options) {
        if (this.preparedQueryFilters != null) {
            for (PreparedQueryFilter filter : this.preparedQueryFilters) {
                sql = filter.filter(sql, options);
            }
        }
        return this.sqlConnection.preparedQuery(sql, options);
    }

    public SqlConnection prepare(String sql, Handler<AsyncResult<PreparedStatement>> handler) {
        return this.sqlConnection.prepare(sql, handler);
    }

    public Future<PreparedStatement> prepare(String sql) {
        return this.sqlConnection.prepare(sql);
    }

    public SqlConnection prepare(String sql, PrepareOptions options, Handler<AsyncResult<PreparedStatement>> handler) {
        return this.sqlConnection.prepare(sql, options, handler);
    }

    public Future<PreparedStatement> prepare(String sql, PrepareOptions options) {
        return this.sqlConnection.prepare(sql, options);
    }

    public SqlConnection exceptionHandler(Handler<Throwable> handler) {
        return this.sqlConnection.exceptionHandler(handler);
    }

    public SqlConnection closeHandler(Handler<Void> handler) {
        return this.sqlConnection.closeHandler(handler);
    }

    public void begin(Handler<AsyncResult<Transaction>> handler) {
        this.sqlConnection.begin(handler);
    }

    public Future<Transaction> begin() {
        return this.sqlConnection.begin();
    }

    public Transaction transaction() {
        return this.sqlConnection.transaction();
    }

    public boolean isSSL() {
        return this.sqlConnection.isSSL();
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.sqlConnection.close(handler);
    }

    public DatabaseMetadata databaseMetadata() {
        return this.sqlConnection.databaseMetadata();
    }

    public Future<Void> close() {
        return this.sqlConnection.close();
    }

    @Generated
    public TransactionRepositoryImpl(TransactionOptions options, SqlConnection sqlConnection, Transaction transaction, DaoManager daoManager, List<PreparedQueryFilter> preparedQueryFilters) {
        this.options = options;
        this.sqlConnection = sqlConnection;
        this.transaction = transaction;
        this.daoManager = daoManager;
        this.preparedQueryFilters = preparedQueryFilters;
    }
}

