/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.db.orm.util;

import io.github.adiitgg.vertx.db.orm.DaoManager;
import io.github.adiitgg.vertx.db.orm.model.EntityFieldOptions;
import io.github.adiitgg.vertx.db.orm.model.EntityOptions;
import io.github.adiitgg.vertx.db.orm.model.diff.DiffSnapshot;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class DiffUtil {
    public static DiffSnapshot snapshot(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("entity is null");
        }
        EntityOptions options = DaoManager.getInstance().getEntityOptions(entity.getClass());
        ArrayList<Object> entityValues = new ArrayList<Object>(options.entityFieldOptions().size());
        for (EntityFieldOptions entityFieldOption : options.entityFieldOptions()) {
            entityValues.add(DiffUtil.wrap(entityFieldOption.fieldWrapper().getter().apply(entity)));
        }
        return new DiffSnapshot().entityOptions(options).values(entityValues);
    }

    public static List<EntityFieldOptions> diff(DiffSnapshot diffSnapshot, Object newEntity) {
        if (diffSnapshot == null) {
            throw new IllegalArgumentException("snapshot is null");
        }
        if (newEntity == null) {
            throw new IllegalArgumentException("entity is null");
        }
        EntityOptions options = DaoManager.getInstance().getEntityOptions(newEntity.getClass());
        ArrayList<EntityFieldOptions> diffProperty = new ArrayList<EntityFieldOptions>();
        int index = 0;
        for (EntityFieldOptions entityFieldOption : options.entityFieldOptions()) {
            Object newValue;
            Object oldValue = diffSnapshot.values().get(index);
            if (!Objects.equals(oldValue, newValue = DiffUtil.wrap(entityFieldOption.fieldWrapper().getter().apply(newEntity)))) {
                diffProperty.add(entityFieldOption);
            }
            ++index;
        }
        return diffProperty;
    }

    public static Object wrap(Object value) {
        if (value instanceof JsonObject) {
            JsonObject o = (JsonObject)value;
            JsonObject newObject = new JsonObject();
            for (Map.Entry stringObjectEntry : o) {
                newObject.put((String)stringObjectEntry.getKey(), DiffUtil.wrap(stringObjectEntry.getValue()));
            }
            return newObject;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap newMap = new LinkedHashMap();
            for (Map.Entry entry : map.entrySet()) {
                newMap.put(entry.getKey(), DiffUtil.wrap(entry.getValue()));
            }
            return newMap;
        }
        if (value instanceof JsonArray) {
            JsonArray ar = (JsonArray)value;
            JsonArray newArray = new JsonArray();
            for (Object o : ar) {
                newArray.add(DiffUtil.wrap(o));
            }
            return newArray;
        }
        if (value instanceof List) {
            List list = (List)value;
            return new ArrayList(list);
        }
        return value;
    }
}

