/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.db.orm.util;

import io.github.adiitgg.vertx.db.orm.model.PreparedQuery;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.impl.logging.Logger;
import java.util.Objects;
import lombok.Generated;

public final class RepositoryUtil {
    public static void logQueryEntity(Logger log, PreparedQuery preparedQuery) {
        log.debug((Object)("SQL: " + preparedQuery.sql()));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < preparedQuery.tuple().size(); ++i) {
            if (!sb.isEmpty()) {
                sb.append(" - ");
            }
            sb.append(i).append("=").append(preparedQuery.tuple().getValue(i));
        }
        log.debug((Object)("Parameters: " + String.valueOf(sb)));
    }

    public static <T> Handler<AsyncResult<T>> logQuery(Logger log, Long maxQueryTookTime, long startTime, String sql) {
        long tookTime = System.currentTimeMillis() - startTime;
        long maxQueryTook = Objects.requireNonNullElse(maxQueryTookTime, 2000L);
        return ar -> {
            if (tookTime > maxQueryTook) {
                log.warn((Object)("Query too slow! " + tookTime + "ms, Maximum time allowed: " + maxQueryTook + "ms. SQL: " + sql));
            }
            if (ar.failed()) {
                Throwable e = ar.cause();
                log.error((Object)("Error Query SQL: " + sql + " -> " + e.getMessage()));
                log.error((Object)"Error from code", e.getCause());
            }
        };
    }

    @Generated
    private RepositoryUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

