/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.db.orm.util;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;

public final class Utils {
    public static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private static final Map<Class<?>, Class<?>> typeMapping = new HashMap();
    private static final MethodHandle INSTANT_NOW;
    private static final MethodHandle OFFSETDATETIME_NOW;
    private static final MethodHandle OFFSETTIME_NOW;
    private static final MethodHandle LOCALTIME_NOW;
    private static final MethodHandle LOCALDATE_NOW;
    private static final MethodHandle LOCALDATETIME_NOW;
    private static final MethodHandle YEAR_NOW;
    private static final MethodHandle YEARMONTH_NOW;
    private static final MethodHandle ZONEDDATETIME_NOW;

    public static String snakeToCamel(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        int length = input.length();
        StringBuilder result = new StringBuilder(length);
        boolean toUpperCase = false;
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            if (c == '_') {
                toUpperCase = true;
                continue;
            }
            if (toUpperCase) {
                result.append(Character.toUpperCase(c));
                toUpperCase = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String toSnakeCase(String input) {
        char[] chars;
        if (input == null || input.isEmpty()) {
            return "";
        }
        StringBuilder snakeCase = new StringBuilder();
        for (char c : chars = input.toCharArray()) {
            if (Character.isUpperCase(c)) {
                snakeCase.append('_').append(Character.toLowerCase(c));
                continue;
            }
            snakeCase.append(c);
        }
        if (snakeCase.charAt(0) == '_') {
            snakeCase.deleteCharAt(0);
        }
        return snakeCase.toString();
    }

    public static <T, R> Function<T, R> createGetter(Field field) {
        if (!field.trySetAccessible()) {
            throw new IllegalAccessException("can't access modifier field");
        }
        MethodHandle getter = lookup.unreflectGetter(field);
        MethodType type = getter.type();
        if (type.hasPrimitives()) {
            type = type.changeReturnType(typeMapping.get(type.returnType()));
            getter = getter.asType(type);
        }
        CallSite site = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class, MethodHandle.class), type.erase(), MethodHandles.exactInvoker(type), type);
        return site.getTarget().invokeExact(getter);
    }

    public static <T, V> BiConsumer<T, V> createSetter(Field field) {
        if (!field.trySetAccessible()) {
            throw new IllegalAccessException("can't access modifier field");
        }
        MethodHandle setter = lookup.unreflectSetter(field);
        MethodType type = setter.type();
        if (field.getType().isPrimitive()) {
            type = type.wrap().changeReturnType(Void.TYPE);
        }
        CallSite site = LambdaMetafactory.metafactory(lookup, "accept", MethodType.methodType(BiConsumer.class, MethodHandle.class), type.erase(), MethodHandles.exactInvoker(setter.type()), type);
        return site.getTarget().invokeExact(setter);
    }

    public static MethodHandle findTimeStaticMHByType(Class<?> type) {
        MethodHandle methodHandle;
        if (type.equals(Instant.class)) {
            methodHandle = INSTANT_NOW;
        } else if (type.equals(OffsetDateTime.class)) {
            methodHandle = OFFSETDATETIME_NOW;
        } else if (type.equals(OffsetTime.class)) {
            methodHandle = OFFSETTIME_NOW;
        } else if (type.equals(LocalTime.class)) {
            methodHandle = LOCALTIME_NOW;
        } else if (type.equals(LocalDate.class)) {
            methodHandle = LOCALDATE_NOW;
        } else if (type.equals(LocalDateTime.class)) {
            methodHandle = LOCALDATETIME_NOW;
        } else if (type.equals(Year.class)) {
            methodHandle = YEAR_NOW;
        } else if (type.equals(YearMonth.class)) {
            methodHandle = YEARMONTH_NOW;
        } else if (type.equals(ZonedDateTime.class)) {
            methodHandle = ZONEDDATETIME_NOW;
        } else {
            throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
        }
        return methodHandle;
    }

    @Generated
    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        try {
            INSTANT_NOW = lookup.findStatic(Instant.class, "now", MethodType.methodType(Instant.class));
            OFFSETDATETIME_NOW = lookup.findStatic(OffsetDateTime.class, "now", MethodType.methodType(OffsetDateTime.class));
            OFFSETTIME_NOW = lookup.findStatic(OffsetTime.class, "now", MethodType.methodType(OffsetTime.class));
            LOCALTIME_NOW = lookup.findStatic(LocalTime.class, "now", MethodType.methodType(LocalTime.class));
            LOCALDATE_NOW = lookup.findStatic(LocalDate.class, "now", MethodType.methodType(LocalDate.class));
            LOCALDATETIME_NOW = lookup.findStatic(LocalDateTime.class, "now", MethodType.methodType(LocalDateTime.class));
            YEAR_NOW = lookup.findStatic(Year.class, "now", MethodType.methodType(Year.class));
            YEARMONTH_NOW = lookup.findStatic(YearMonth.class, "now", MethodType.methodType(YearMonth.class));
            ZONEDDATETIME_NOW = lookup.findStatic(ZonedDateTime.class, "now", MethodType.methodType(ZonedDateTime.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        typeMapping.put(Boolean.TYPE, Boolean.class);
        typeMapping.put(Byte.TYPE, Byte.class);
        typeMapping.put(Short.TYPE, Short.class);
        typeMapping.put(Character.TYPE, Character.class);
        typeMapping.put(Integer.TYPE, Integer.class);
        typeMapping.put(Long.TYPE, Long.class);
        typeMapping.put(Float.TYPE, Float.class);
        typeMapping.put(Double.TYPE, Double.class);
    }
}

