/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.http.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.DecodeException;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.function.Function;

public class DefaultExceptionHandler
implements Function<RoutingContext, Buffer> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Buffer apply(RoutingContext context) {
        Throwable exception = context.failure();
        if (exception instanceof InterruptedException) {
            return Buffer.buffer((String)"SERVER CLOSED!");
        }
        if (exception instanceof DecodeException) {
            this.log.info((Object)("error parsing data: " + exception.getMessage()));
            return Buffer.buffer((String)"Invalid Request!");
        }
        if (exception instanceof IOException) {
            context.response().reset();
            return null;
        }
        return null;
    }
}

