/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.http.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.adiitgg.vertx.http.RouterBuilder;
import io.github.adiitgg.vertx.http.annotation.http.API;
import io.github.adiitgg.vertx.http.annotation.middleware.AuthMiddleware;
import io.github.adiitgg.vertx.http.annotation.middleware.Middleware;
import io.github.adiitgg.vertx.http.annotation.route.Authenticated;
import io.github.adiitgg.vertx.http.impl.DefaultExceptionHandler;
import io.github.adiitgg.vertx.http.invoker.MethodInvoker;
import io.github.adiitgg.vertx.http.invoker.impl.RunnableMethodInvokerFactory;
import io.github.adiitgg.vertx.http.invoker.impl.SupplierMethodInvokerFactory;
import io.github.adiitgg.vertx.http.invoker.impl.consumer.A3ConsumerMethodInvokerFactory;
import io.github.adiitgg.vertx.http.invoker.impl.consumer.A4ConsumerMethodInvokerFactory;
import io.github.adiitgg.vertx.http.invoker.impl.consumer.A5ConsumerMethodInvokerFactory;
import io.github.adiitgg.vertx.http.invoker.impl.consumer.A6ConsumerMethodInvokerFactory;
import io.github.adiitgg.vertx.http.invoker.impl.consumer.A7ConsumerMethodInvokerFactory;
import io.github.adiitgg.vertx.http.invoker.impl.consumer.BiConsumerMethodInvokerFactory;
import io.github.adiitgg.vertx.http.invoker.impl.consumer.ConsumerMethodInvokerFactory;
import io.github.adiitgg.vertx.http.invoker.impl.function.A3FunctionMethodInvokerFactory;
import io.github.adiitgg.vertx.http.invoker.impl.function.A4FunctionMethodInvokerFactory;
import io.github.adiitgg.vertx.http.invoker.impl.function.A5FunctionMethodInvokerFactory;
import io.github.adiitgg.vertx.http.invoker.impl.function.A6FunctionMethodInvokerFactory;
import io.github.adiitgg.vertx.http.invoker.impl.function.A7FunctionMethodInvokerFactory;
import io.github.adiitgg.vertx.http.invoker.impl.function.BiFunctionMethodInvokerFactory;
import io.github.adiitgg.vertx.http.invoker.impl.function.FunctionMethodInvokerFactory;
import io.github.adiitgg.vertx.http.model.MethodApi;
import io.github.adiitgg.vertx.http.model.RouteContext;
import io.github.adiitgg.vertx.http.model.RouteOptions;
import io.github.adiitgg.vertx.http.param.ParameterProvider;
import io.github.adiitgg.vertx.http.param.impl.CompositeParameterProviderFactory;
import io.github.adiitgg.vertx.http.param.impl.ContextDataParamProviderFactory;
import io.github.adiitgg.vertx.http.param.impl.HttpServerRequestParamProviderFactory;
import io.github.adiitgg.vertx.http.param.impl.HttpServerResponseParamProviderFactory;
import io.github.adiitgg.vertx.http.param.impl.RequestBodyParamProviderFactory;
import io.github.adiitgg.vertx.http.param.impl.RequestFormParamProviderFactory;
import io.github.adiitgg.vertx.http.param.impl.RequestHeadersParamProviderFactory;
import io.github.adiitgg.vertx.http.param.impl.RequestPathParamProviderFactory;
import io.github.adiitgg.vertx.http.param.impl.RequestQueryParamProviderFactory;
import io.github.adiitgg.vertx.http.param.impl.RequestQueryParamsProviderFactory;
import io.github.adiitgg.vertx.http.param.impl.RoutingContextParamProviderFactory;
import io.github.adiitgg.vertx.http.param.impl.SessionParamProviderFactory;
import io.github.adiitgg.vertx.http.param.impl.UserContextParamProviderFactory;
import io.github.adiitgg.vertx.http.param.impl.UserParamProviderFactory;
import io.github.adiitgg.vertx.http.param.impl.VertxParamProviderFactory;
import io.github.adiitgg.vertx.http.processor.RouteAnnotationProcessor;
import io.github.adiitgg.vertx.http.processor.impl.AuthenticatedRouteAnnotationProcessor;
import io.github.adiitgg.vertx.http.processor.impl.BlockingRouteAnnotationProcessor;
import io.github.adiitgg.vertx.http.processor.impl.CompositeRouteAnnotationProcessor;
import io.github.adiitgg.vertx.http.processor.impl.ConsumesRouteAnnotationProcessor;
import io.github.adiitgg.vertx.http.processor.impl.DisabledRouteAnnotationProcessor;
import io.github.adiitgg.vertx.http.processor.impl.ExcludeMethodPathRouteAnnotationProcessor;
import io.github.adiitgg.vertx.http.processor.impl.LogsRouteAnnotationProcessor;
import io.github.adiitgg.vertx.http.processor.impl.NameRouteAnnotationProcessor;
import io.github.adiitgg.vertx.http.processor.impl.NoResponseWriterRouteAnnotationProcessor;
import io.github.adiitgg.vertx.http.processor.impl.OrderRouteAnnotationProcessor;
import io.github.adiitgg.vertx.http.processor.impl.PathRegexRouteAnnotationProcessor;
import io.github.adiitgg.vertx.http.processor.impl.ProducesRouteAnnotationProcessor;
import io.github.adiitgg.vertx.http.processor.impl.VirtualHostRouteAnnotationProcessor;
import io.github.adiitgg.vertx.http.request.RequestReader;
import io.github.adiitgg.vertx.http.request.RequestValidation;
import io.github.adiitgg.vertx.http.request.impl.CompositeRequestReader;
import io.github.adiitgg.vertx.http.request.impl.FormRequestReader;
import io.github.adiitgg.vertx.http.request.impl.HeadersRequestReader;
import io.github.adiitgg.vertx.http.request.impl.JsonRequestBodyReader;
import io.github.adiitgg.vertx.http.request.impl.PathParamRequestReader;
import io.github.adiitgg.vertx.http.request.impl.QueryParamsRequestReader;
import io.github.adiitgg.vertx.http.request.impl.validation.JakartaValidationRequest;
import io.github.adiitgg.vertx.http.response.HttpResponseLogging;
import io.github.adiitgg.vertx.http.response.ResponseMapper;
import io.github.adiitgg.vertx.http.response.ResponseWriter;
import io.github.adiitgg.vertx.http.response.impl.CompositeResponseWriter;
import io.github.adiitgg.vertx.http.response.impl.GeneralResponseWriter;
import io.github.adiitgg.vertx.http.response.impl.HttpResponseLoggingImpl;
import io.github.adiitgg.vertx.http.response.impl.JsonResponseWriter;
import io.github.adiitgg.vertx.http.route.MiddlewareHandler;
import io.github.adiitgg.vertx.http.route.OnRegisteringRoute;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public class RouterBuilderImpl
implements RouterBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<MethodInvoker.Factory> methodInvokerFactories = new ArrayList<MethodInvoker.Factory>();
    private final List<RequestReader> requestReaders = new ArrayList<RequestReader>();
    private final List<ResponseWriter> responseWriters = new ArrayList<ResponseWriter>();
    private final List<ParameterProvider.Factory> parameterProviderFactories = new ArrayList<ParameterProvider.Factory>();
    private final List<RouteAnnotationProcessor> routeAnnotationProcessors = new ArrayList<RouteAnnotationProcessor>();
    private final List<RequestValidation> requestValidations = new ArrayList<RequestValidation>();
    private final List<OnRegisteringRoute> onRegisteringRoutes = new ArrayList<OnRegisteringRoute>();
    private HttpResponseLogging httpResponseLogging;
    private Function<RoutingContext, Buffer> exceptionHandler;
    private ResponseMapper responseMapper;
    private Router router;
    private List<Object> routerInstances;

    public RouterBuilderImpl() {
        DatabindCodec databindCodec = (DatabindCodec)Json.CODEC;
        ObjectMapper objectMapper = DatabindCodec.mapper().findAndRegisterModules();
        this.requestReaders.add(new JsonRequestBodyReader(databindCodec));
        this.requestReaders.add(new QueryParamsRequestReader(databindCodec));
        this.requestReaders.add(new HeadersRequestReader(databindCodec));
        this.requestReaders.add(new PathParamRequestReader(databindCodec));
        this.requestReaders.add(new FormRequestReader(databindCodec));
        this.responseWriters.add(new JsonResponseWriter());
        this.responseWriters.add(new GeneralResponseWriter());
        CompositeRequestReader compositeRequestReaders = new CompositeRequestReader(this.requestReaders, this.requestValidations);
        this.parameterProviderFactories.add(new RoutingContextParamProviderFactory());
        this.parameterProviderFactories.add(new HttpServerRequestParamProviderFactory());
        this.parameterProviderFactories.add(new HttpServerResponseParamProviderFactory());
        this.parameterProviderFactories.add(new RequestBodyParamProviderFactory(compositeRequestReaders));
        this.parameterProviderFactories.add(new RequestQueryParamProviderFactory(objectMapper));
        this.parameterProviderFactories.add(new RequestQueryParamsProviderFactory(compositeRequestReaders));
        this.parameterProviderFactories.add(new RequestHeadersParamProviderFactory(compositeRequestReaders));
        this.parameterProviderFactories.add(new RequestPathParamProviderFactory(compositeRequestReaders));
        this.parameterProviderFactories.add(new RequestFormParamProviderFactory(compositeRequestReaders));
        this.parameterProviderFactories.add(new UserParamProviderFactory());
        this.parameterProviderFactories.add(new UserContextParamProviderFactory());
        this.parameterProviderFactories.add(new VertxParamProviderFactory());
        this.parameterProviderFactories.add(new ContextDataParamProviderFactory());
        this.parameterProviderFactories.add(new SessionParamProviderFactory());
        this.methodInvokerFactories.add(new RunnableMethodInvokerFactory());
        this.methodInvokerFactories.add(new SupplierMethodInvokerFactory());
        this.methodInvokerFactories.add(new ConsumerMethodInvokerFactory());
        this.methodInvokerFactories.add(new BiConsumerMethodInvokerFactory());
        this.methodInvokerFactories.add(new A3ConsumerMethodInvokerFactory());
        this.methodInvokerFactories.add(new A4ConsumerMethodInvokerFactory());
        this.methodInvokerFactories.add(new A5ConsumerMethodInvokerFactory());
        this.methodInvokerFactories.add(new A6ConsumerMethodInvokerFactory());
        this.methodInvokerFactories.add(new A7ConsumerMethodInvokerFactory());
        this.methodInvokerFactories.add(new FunctionMethodInvokerFactory());
        this.methodInvokerFactories.add(new BiFunctionMethodInvokerFactory());
        this.methodInvokerFactories.add(new A3FunctionMethodInvokerFactory());
        this.methodInvokerFactories.add(new A4FunctionMethodInvokerFactory());
        this.methodInvokerFactories.add(new A5FunctionMethodInvokerFactory());
        this.methodInvokerFactories.add(new A6FunctionMethodInvokerFactory());
        this.methodInvokerFactories.add(new A7FunctionMethodInvokerFactory());
        this.routeAnnotationProcessors.add(new AuthenticatedRouteAnnotationProcessor());
        this.routeAnnotationProcessors.add(new ConsumesRouteAnnotationProcessor());
        this.routeAnnotationProcessors.add(new DisabledRouteAnnotationProcessor());
        this.routeAnnotationProcessors.add(new NameRouteAnnotationProcessor());
        this.routeAnnotationProcessors.add(new ExcludeMethodPathRouteAnnotationProcessor());
        this.routeAnnotationProcessors.add(new NoResponseWriterRouteAnnotationProcessor());
        this.routeAnnotationProcessors.add(new OrderRouteAnnotationProcessor());
        this.routeAnnotationProcessors.add(new PathRegexRouteAnnotationProcessor());
        this.routeAnnotationProcessors.add(new ProducesRouteAnnotationProcessor());
        this.routeAnnotationProcessors.add(new VirtualHostRouteAnnotationProcessor());
        this.routeAnnotationProcessors.add(new BlockingRouteAnnotationProcessor());
        this.routeAnnotationProcessors.add(new LogsRouteAnnotationProcessor());
        this.requestValidations.add(new JakartaValidationRequest());
        this.httpResponseLogging = new HttpResponseLoggingImpl();
        this.exceptionHandler = new DefaultExceptionHandler();
    }

    protected <T> RouterBuilderImpl checkAddFirst(List<T> list, T t) {
        if (t == null) {
            return this;
        }
        for (T t1 : list) {
            if (!t1.getClass().equals(t.getClass())) continue;
            return this;
        }
        list.add(t);
        return this;
    }

    protected <T> RouterBuilderImpl checkRemove(List<T> list, Class<?> clazz) {
        list.removeIf(context -> context.getClass().equals(clazz));
        return this;
    }

    @Override
    public RouterBuilderImpl addMethodInvokerFactory(MethodInvoker.Factory methodInvokerFactory) {
        return this.checkAddFirst(this.methodInvokerFactories, methodInvokerFactory);
    }

    @Override
    public RouterBuilderImpl removeMethodInvokerFactory(Class<?> clazz) {
        return this.checkRemove(this.methodInvokerFactories, clazz);
    }

    @Override
    public RouterBuilderImpl addRequestReader(RequestReader requestReader) {
        return this.checkAddFirst(this.requestReaders, requestReader);
    }

    @Override
    public RouterBuilderImpl removeRequestReader(Class<?> clazz) {
        return this.checkRemove(this.requestReaders, clazz);
    }

    @Override
    public RouterBuilderImpl addResponseWriter(ResponseWriter responseWriter) {
        return this.checkAddFirst(this.responseWriters, responseWriter);
    }

    @Override
    public RouterBuilderImpl removeResponseWriter(Class<?> clazz) {
        return this.checkRemove(this.responseWriters, clazz);
    }

    @Override
    public RouterBuilderImpl addParameterProviderFactory(ParameterProvider.Factory parameterProviderFactory) {
        return this.checkAddFirst(this.parameterProviderFactories, parameterProviderFactory);
    }

    @Override
    public RouterBuilderImpl removeParameterProviderFactory(Class<?> clazz) {
        return this.checkRemove(this.parameterProviderFactories, clazz);
    }

    @Override
    public RouterBuilderImpl addRouteAnnotationProcessor(RouteAnnotationProcessor routeAnnotationProcessor) {
        return this.checkAddFirst(this.routeAnnotationProcessors, routeAnnotationProcessor);
    }

    @Override
    public RouterBuilderImpl removeRouteAnnotationProcessor(Class<?> clazz) {
        return this.checkRemove(this.routeAnnotationProcessors, clazz);
    }

    @Override
    public RouterBuilderImpl addRequestValidation(RequestValidation requestValidation) {
        return this.checkAddFirst(this.requestValidations, requestValidation);
    }

    @Override
    public RouterBuilderImpl removeRequestValidation(Class<?> clazz) {
        return this.checkRemove(this.requestReaders, clazz);
    }

    @Override
    public RouterBuilderImpl setRequestValidations(List<RequestValidation> requestValidations) {
        this.requestValidations.clear();
        this.requestValidations.addAll(requestValidations);
        return this;
    }

    protected Class<?> isAssignable(Class<?> from, Class<?> to, Class<?> target) {
        if (target != null) {
            return target;
        }
        if (to.isAssignableFrom(from)) {
            return to;
        }
        return null;
    }

    @Override
    public RouterBuilderImpl registerModules(List<Object> modules) {
        Map<Class, List<Object>> grouped = modules.stream().collect(Collectors.groupingBy(module -> {
            Class<?> clazz = module.getClass();
            Class<?> target = null;
            target = this.isAssignable(clazz, MethodInvoker.Factory.class, target);
            target = this.isAssignable(clazz, RequestReader.class, target);
            target = this.isAssignable(clazz, ResponseWriter.class, target);
            target = this.isAssignable(clazz, ParameterProvider.Factory.class, target);
            target = this.isAssignable(clazz, RouteAnnotationProcessor.class, target);
            return (target = this.isAssignable(clazz, RequestValidation.class, target)) == null ? clazz : target;
        }));
        grouped.getOrDefault(MethodInvoker.Factory.class, Collections.emptyList()).stream().map(context -> (MethodInvoker.Factory)context).forEach(this::addMethodInvokerFactory);
        grouped.getOrDefault(RequestReader.class, Collections.emptyList()).stream().map(context -> (RequestReader)context).forEach(this::addRequestReader);
        grouped.getOrDefault(ResponseWriter.class, Collections.emptyList()).stream().map(context -> (ResponseWriter)context).forEach(this::addResponseWriter);
        grouped.getOrDefault(ParameterProvider.Factory.class, Collections.emptyList()).stream().map(context -> (ParameterProvider.Factory)context).forEach(this::addParameterProviderFactory);
        grouped.getOrDefault(RouteAnnotationProcessor.class, Collections.emptyList()).stream().map(context -> (RouteAnnotationProcessor)context).forEach(this::addRouteAnnotationProcessor);
        grouped.getOrDefault(RequestValidation.class, Collections.emptyList()).stream().map(context -> (RequestValidation)context).forEach(this::addRequestValidation);
        return this;
    }

    @Override
    public RouterBuilderImpl httpResponseLogging(HttpResponseLogging httpResponseLogging) {
        this.httpResponseLogging = httpResponseLogging;
        return this;
    }

    @Override
    public RouterBuilderImpl addOnRegisteringRoute(OnRegisteringRoute listener) {
        this.onRegisteringRoutes.add(listener);
        return this;
    }

    @Override
    public RouterBuilderImpl removeOnRegisteringRoute(OnRegisteringRoute listener) {
        this.onRegisteringRoutes.remove(listener);
        return this;
    }

    @Override
    public RouterBuilderImpl exceptionHandler(Function<RoutingContext, Buffer> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    public RouterBuilderImpl responseMapper(ResponseMapper responseMapper) {
        this.responseMapper = responseMapper;
        return this;
    }

    @Override
    public RouterBuilderImpl init(Router router, String defaultResponseContentType) {
        this.router = router;
        router.route().handler(context -> {
            context.put("START_DTOFFSET", (Object)OffsetDateTime.now());
            context.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)defaultResponseContentType);
            context.addEndHandler(v -> {
                Buffer buffer = (Buffer)context.get("RES_BODY_BUFF");
                this.httpResponseLogging.log((RoutingContext)context, buffer);
            });
            context.next();
        });
        return this;
    }

    @Override
    public RouterBuilderImpl init(Router router) {
        return this.init(router, HttpHeaderValues.APPLICATION_JSON.toString());
    }

    @Override
    public RouterBuilderImpl withBodyHandler() {
        this.router.route().handler((Handler)BodyHandler.create());
        return this;
    }

    @Override
    public RouterBuilderImpl routers(List<Object> routerInstances) {
        this.routerInstances = routerInstances;
        return this;
    }

    @Override
    public RouterBuilderImpl appendRouter() {
        return this.append((List)this.routerInstances);
    }

    @Override
    public RouterBuilderImpl append(List<Object> classInstances) {
        return this.append(this.router, (List)classInstances);
    }

    @Override
    public RouterBuilderImpl append(Router router, List<Object> classInstances) {
        CompositeResponseWriter compositeResponseWriter = new CompositeResponseWriter(this.responseWriters.toArray(new ResponseWriter[0]), this.responseMapper);
        CompositeParameterProviderFactory compositeParameterProviderFactory = new CompositeParameterProviderFactory(this.parameterProviderFactories.toArray(new ParameterProvider.Factory[0]));
        CompositeRouteAnnotationProcessor compositeRouteAnnotationProcessor = new CompositeRouteAnnotationProcessor(this.routeAnnotationProcessors.toArray(new RouteAnnotationProcessor[0]));
        Map<Boolean, List<RouteContext>> middlewaresAuth = classInstances.stream().map(context -> this.getMiddleware(context, compositeRouteAnnotationProcessor)).filter(Objects::nonNull).collect(Collectors.groupingBy(context -> context.options().auth()));
        Map<Boolean, List<RouteContext>> groupedMiddlewares = middlewaresAuth.getOrDefault(false, Collections.emptyList()).stream().collect(Collectors.groupingBy(context -> context.options().getOrDefault("beforeAuth", true)));
        AtomicReference middlewaresBeforeAuth = new AtomicReference(groupedMiddlewares.getOrDefault(true, Collections.emptyList()));
        AtomicReference middlewaresAfterAuth = new AtomicReference(groupedMiddlewares.getOrDefault(false, Collections.emptyList()));
        AtomicReference authMiddlewares = new AtomicReference(middlewaresAuth.getOrDefault(true, Collections.emptyList()));
        Map<Boolean, List<MethodApi>> groupedApiMethods = classInstances.stream().filter(context -> context != null && context.getClass().isAnnotationPresent(io.github.adiitgg.vertx.http.annotation.route.Route.class)).flatMap(context -> this.findApiMethods(context, compositeRouteAnnotationProcessor).stream().filter(Objects::nonNull)).collect(Collectors.groupingBy(ma -> ma.options().auth()));
        Runnable registerMiddleware = () -> middlewaresBeforeAuth.set(this.tryRegisterMiddleware(router, (List)middlewaresBeforeAuth.get()));
        registerMiddleware.run();
        for (MethodApi methodApi : groupedApiMethods.getOrDefault(false, Collections.emptyList())) {
            this.registerRoute(router, methodApi, compositeParameterProviderFactory, compositeResponseWriter);
            registerMiddleware.run();
        }
        Runnable registerAuthMiddleware = () -> authMiddlewares.set(this.tryRegisterMiddleware(router, (List)authMiddlewares.get()));
        registerAuthMiddleware.run();
        registerMiddleware = () -> middlewaresAfterAuth.set(this.tryRegisterMiddleware(router, (List)middlewaresAfterAuth.get()));
        registerMiddleware.run();
        for (MethodApi methodApi : groupedApiMethods.getOrDefault(true, Collections.emptyList())) {
            this.registerRoute(router, methodApi, compositeParameterProviderFactory, compositeResponseWriter);
            registerAuthMiddleware.run();
            registerMiddleware.run();
        }
        if (!middlewaresBeforeAuth.get().isEmpty()) {
            this.log.warn((Object)("No route registered for: " + String.valueOf(middlewaresBeforeAuth.get())));
        }
        if (!authMiddlewares.get().isEmpty()) {
            this.log.warn((Object)("No route registered for: " + String.valueOf(authMiddlewares.get())));
        }
        if (!middlewaresAfterAuth.get().isEmpty()) {
            this.log.warn((Object)("No route registered for: " + String.valueOf(middlewaresAfterAuth.get())));
        }
        if (this.exceptionHandler != null) {
            router.route().failureHandler(context -> compositeResponseWriter.write((RoutingContext)context, this.exceptionHandler.apply((RoutingContext)context)));
        }
        return this;
    }

    protected List<RouteContext> tryRegisterMiddleware(Router router, List<RouteContext> list) {
        return list.stream().filter(context -> {
            Object patt0$temp;
            RouteOptions options = context.options();
            Route route = router.route();
            if (options.method() != null) {
                route = route.method(HttpMethod.valueOf((String)options.method().name()));
            }
            if (options.consumes() != null) {
                for (String consume : options.consumes()) {
                    route = route.consumes(consume);
                }
            }
            if (options.produces() != null) {
                for (String produce : options.produces()) {
                    route = route.produces(produce);
                }
            }
            if (options.order() != null) {
                route = route.order(options.order().intValue());
            }
            if (!options.enable()) {
                route = route.disable();
            }
            if (options.virtualHost() != null) {
                route = route.virtualHost(options.virtualHost());
            }
            if (options.name() != null) {
                route = route.setName(options.name());
            }
            if ((patt0$temp = context.context()) instanceof MiddlewareHandler) {
                MiddlewareHandler mh = (MiddlewareHandler)patt0$temp;
                if ((route = mh.onRegister(route)) != null) {
                    if (options.isBlocking()) {
                        route.blockingHandler((Handler)mh);
                    } else {
                        route.handler((Handler)mh);
                    }
                    return false;
                }
            } else {
                Object patt1$temp = context.context();
                if (patt1$temp instanceof Handler) {
                    Handler handler;
                    Handler h = handler = (Handler)patt1$temp;
                    if (options.isBlocking()) {
                        route.blockingHandler(h);
                    } else {
                        route.handler(h);
                    }
                    return false;
                }
            }
            return true;
        }).toList();
    }

    protected <T extends Annotation> boolean isMiddleware(Object context, Class<T> clazz) {
        return context.getClass().isAnnotationPresent(clazz) && context instanceof Handler;
    }

    protected RouteContext getMiddleware(Object context, RouteAnnotationProcessor routeAnnotationProcessor) {
        boolean isMiddleware = this.isMiddleware(context, Middleware.class);
        boolean isAuthMiddleware = this.isMiddleware(context, AuthMiddleware.class);
        if (!isMiddleware && !isAuthMiddleware) {
            return null;
        }
        List<Annotation> qualifiers = Arrays.stream(context.getClass().getDeclaredAnnotations()).filter(annotation -> annotation.annotationType().isAnnotationPresent(Authenticated.class)).toList();
        RouteOptions options = new RouteOptions();
        routeAnnotationProcessor.process(context, context.getClass(), null, options);
        options.auth(isAuthMiddleware);
        options.put("qualifiers", qualifiers);
        if (isMiddleware) {
            Middleware middleware = context.getClass().getAnnotation(Middleware.class);
            options.put("beforeAuth", middleware.beforeAuth());
        }
        return new RouteContext().context(context).options(options);
    }

    protected List<MethodApi> findApiMethods(Object context, RouteAnnotationProcessor routeAnnotationProcessor) {
        io.github.adiitgg.vertx.http.annotation.route.Route route = context.getClass().getAnnotation(io.github.adiitgg.vertx.http.annotation.route.Route.class);
        return Arrays.stream(context.getClass().getMethods()).map(method -> {
            Optional<Annotation> httpMethodAnnotation = Arrays.stream(method.getDeclaredAnnotations()).filter(annotation -> annotation.annotationType().isAnnotationPresent(API.class)).findFirst();
            if (httpMethodAnnotation.isEmpty()) {
                return null;
            }
            API apiAnnotation = httpMethodAnnotation.get().annotationType().getAnnotation(API.class);
            Annotation annotation2 = httpMethodAnnotation.get();
            Map<String, Object> params = Arrays.stream(annotation2.getClass().getDeclaredMethods()).filter(m -> !m.getReturnType().equals(Void.class) && m.getParameterCount() == 0).collect(Collectors.toMap(Method::getName, m -> {
                try {
                    return m.invoke((Object)annotation2, new Object[0]);
                }
                catch (Throwable e) {
                    this.log.error((Object)("Failed to invoke method: " + m.getName()), e);
                    throw new IllegalArgumentException(e.getMessage());
                }
            }));
            JsonObject optionsJson = new JsonObject(params);
            optionsJson.put("method", (Object)apiAnnotation.method().name());
            optionsJson.put("path", optionsJson.getValue("value"));
            RouteOptions options = (RouteOptions)optionsJson.mapTo(RouteOptions.class);
            routeAnnotationProcessor.process(context, context.getClass(), (Method)method, options);
            MethodInvoker.Factory factory = this.methodInvokerFactories.stream().filter(f -> f.isSupported((Method)method)).findFirst().orElse(null);
            if (factory == null) {
                throw new IllegalArgumentException("Unsupported method: " + method.getName() + ". Missing MethodInvokerFactory for arguments count: " + method.getParameterCount());
            }
            return new MethodApi().route(route).context(context).method((Method)method).options(options).methodInvokerFactory(factory);
        }).toList();
    }

    protected void registerRoute(Router router, MethodApi methodApi, ParameterProvider.Factory parameterProviderFactory, ResponseWriter responseWriter) {
        RouteOptions options = methodApi.options();
        MethodInvoker methodInvoker = methodApi.methodInvokerFactory().create(methodApi.context(), methodApi.method(), parameterProviderFactory);
        String path = methodApi.route().value() + (String)((options.path() == null || options.path().isEmpty()) && options.methodAsPath() ? "/" + methodApi.method().getName().replaceAll("([a-z])([A-Z]+)", "$1-$2").toLowerCase(Locale.ROOT) : options.path());
        Route route = router.route();
        for (OnRegisteringRoute onRegisteringRoute : this.onRegisteringRoutes) {
            route = onRegisteringRoute.before(router, path, methodApi);
        }
        route = route.path(path);
        if (options.pathRegex() != null && !options.pathRegex().isBlank()) {
            route = route.pathRegex(options.pathRegex());
        }
        if (options.method() != null) {
            route = route.method(HttpMethod.valueOf((String)options.method().name()));
        }
        if (options.consumes() != null) {
            for (String consume : options.consumes()) {
                route = route.consumes(consume);
            }
        }
        if (options.produces() != null) {
            for (String produce : options.produces()) {
                route = route.produces(produce);
            }
        }
        if (options.order() != null) {
            route = route.order(options.order().intValue());
        }
        if (!options.enable()) {
            route = route.disable();
        }
        if (options.virtualHost() != null) {
            route = route.virtualHost(options.virtualHost());
        }
        if (options.name() != null) {
            route = route.setName(options.name());
        }
        for (OnRegisteringRoute onRegisteringRoute : this.onRegisteringRoutes) {
            route = onRegisteringRoute.after(route, methodApi);
        }
        route.putMetadata("classMethodHandler", (Object)(methodApi.context().getClass().getName() + " -> " + methodApi.method().getName()));
        if (options.isBlocking()) {
            route.blockingHandler(ctx -> this.handleContext((RoutingContext)ctx, methodInvoker, options, responseWriter), options.blockingOrdered());
            return;
        }
        route.handler(ctx -> this.handleContext((RoutingContext)ctx, methodInvoker, options, responseWriter));
    }

    protected void handleContext(RoutingContext context, MethodInvoker methodInvoker, RouteOptions options, ResponseWriter responseWriter) {
        if (options.produces() != null) {
            context.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)String.join((CharSequence)";", options.produces()));
        }
        if (options.disableRequestLog()) {
            context.put("REQ_NO_LOG", (Object)true);
        }
        if (options.disableResponseLog()) {
            context.put("RES_NO_LOG", (Object)true);
        }
        if (options.noResponseWriter()) {
            return;
        }
        Object result = methodInvoker.invoke(context, options);
        HttpServerResponse response = context.response();
        if (response.ended()) {
            this.log.warn((Object)"Response already ended");
            return;
        }
        boolean written = responseWriter.write(context, result, options);
        if (!written && result != null) {
            throw new IllegalArgumentException("No response writer found for: " + result.getClass().getName());
        }
        if (!response.ended()) {
            if (result != null) {
                this.log.warn((Object)"Response written successfully, but RoutingContext not ended");
            }
            response.end();
        }
    }

    @Override
    @Generated
    public List<MethodInvoker.Factory> getMethodInvokerFactories() {
        return this.methodInvokerFactories;
    }

    @Override
    @Generated
    public List<RequestReader> getRequestReaders() {
        return this.requestReaders;
    }

    @Override
    @Generated
    public List<ResponseWriter> getResponseWriters() {
        return this.responseWriters;
    }

    @Override
    @Generated
    public List<ParameterProvider.Factory> getParameterProviderFactories() {
        return this.parameterProviderFactories;
    }

    @Override
    @Generated
    public List<RouteAnnotationProcessor> getRouteAnnotationProcessors() {
        return this.routeAnnotationProcessors;
    }

    @Override
    @Generated
    public List<RequestValidation> getRequestValidations() {
        return this.requestValidations;
    }

    @Override
    @Generated
    public List<OnRegisteringRoute> getOnRegisteringRoutes() {
        return this.onRegisteringRoutes;
    }
}

