/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.http.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.github.adiitgg.vertx.http.model.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class RouteOptions {
    private String path;
    private String pathRegex;
    private Method method;
    private String[] consumes;
    private String[] produces;
    private Integer order;
    private boolean enable = true;
    private String virtualHost;
    private String name;
    private boolean auth;
    private boolean noResponseWriter;
    private boolean methodAsPath = true;
    private boolean isBlocking;
    private boolean blockingOrdered;
    private Map<String, Object> metaData;
    private boolean disableRequestLog;
    private boolean disableResponseLog;

    public Map<String, Object> metaData() {
        if (this.metaData == null) {
            this.metaData = new HashMap<String, Object>();
        }
        return this.metaData;
    }

    public RouteOptions put(String key, Object value) {
        this.metaData().put(key, value);
        return this;
    }

    public <T> T getOrDefault(String key, T defaultValue) {
        return (T)this.metaData().getOrDefault(key, defaultValue);
    }

    public <T> T get(String key) {
        return (T)this.metaData().get(key);
    }

    @Generated
    public RouteOptions() {
    }

    @Generated
    public String path() {
        return this.path;
    }

    @Generated
    public String pathRegex() {
        return this.pathRegex;
    }

    @Generated
    public Method method() {
        return this.method;
    }

    @Generated
    public String[] consumes() {
        return this.consumes;
    }

    @Generated
    public String[] produces() {
        return this.produces;
    }

    @Generated
    public Integer order() {
        return this.order;
    }

    @Generated
    public boolean enable() {
        return this.enable;
    }

    @Generated
    public String virtualHost() {
        return this.virtualHost;
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public boolean auth() {
        return this.auth;
    }

    @Generated
    public boolean noResponseWriter() {
        return this.noResponseWriter;
    }

    @Generated
    public boolean methodAsPath() {
        return this.methodAsPath;
    }

    @Generated
    public boolean isBlocking() {
        return this.isBlocking;
    }

    @Generated
    public boolean blockingOrdered() {
        return this.blockingOrdered;
    }

    @Generated
    public boolean disableRequestLog() {
        return this.disableRequestLog;
    }

    @Generated
    public boolean disableResponseLog() {
        return this.disableResponseLog;
    }

    @Generated
    public RouteOptions path(String path) {
        this.path = path;
        return this;
    }

    @Generated
    public RouteOptions pathRegex(String pathRegex) {
        this.pathRegex = pathRegex;
        return this;
    }

    @Generated
    public RouteOptions method(Method method) {
        this.method = method;
        return this;
    }

    @Generated
    public RouteOptions consumes(String[] consumes) {
        this.consumes = consumes;
        return this;
    }

    @Generated
    public RouteOptions produces(String[] produces) {
        this.produces = produces;
        return this;
    }

    @Generated
    public RouteOptions order(Integer order) {
        this.order = order;
        return this;
    }

    @Generated
    public RouteOptions enable(boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public RouteOptions virtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
        return this;
    }

    @Generated
    public RouteOptions name(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public RouteOptions auth(boolean auth) {
        this.auth = auth;
        return this;
    }

    @Generated
    public RouteOptions noResponseWriter(boolean noResponseWriter) {
        this.noResponseWriter = noResponseWriter;
        return this;
    }

    @Generated
    public RouteOptions methodAsPath(boolean methodAsPath) {
        this.methodAsPath = methodAsPath;
        return this;
    }

    @Generated
    public RouteOptions isBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
        return this;
    }

    @Generated
    public RouteOptions blockingOrdered(boolean blockingOrdered) {
        this.blockingOrdered = blockingOrdered;
        return this;
    }

    @Generated
    public RouteOptions metaData(Map<String, Object> metaData) {
        this.metaData = metaData;
        return this;
    }

    @Generated
    public RouteOptions disableRequestLog(boolean disableRequestLog) {
        this.disableRequestLog = disableRequestLog;
        return this;
    }

    @Generated
    public RouteOptions disableResponseLog(boolean disableResponseLog) {
        this.disableResponseLog = disableResponseLog;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RouteOptions)) {
            return false;
        }
        RouteOptions other = (RouteOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.enable() != other.enable()) {
            return false;
        }
        if (this.auth() != other.auth()) {
            return false;
        }
        if (this.noResponseWriter() != other.noResponseWriter()) {
            return false;
        }
        if (this.methodAsPath() != other.methodAsPath()) {
            return false;
        }
        if (this.isBlocking() != other.isBlocking()) {
            return false;
        }
        if (this.blockingOrdered() != other.blockingOrdered()) {
            return false;
        }
        if (this.disableRequestLog() != other.disableRequestLog()) {
            return false;
        }
        if (this.disableResponseLog() != other.disableResponseLog()) {
            return false;
        }
        Integer this$order = this.order();
        Integer other$order = other.order();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        String this$path = this.path();
        String other$path = other.path();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$pathRegex = this.pathRegex();
        String other$pathRegex = other.pathRegex();
        if (this$pathRegex == null ? other$pathRegex != null : !this$pathRegex.equals(other$pathRegex)) {
            return false;
        }
        Method this$method = this.method();
        Method other$method = other.method();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        if (!Arrays.deepEquals(this.consumes(), other.consumes())) {
            return false;
        }
        if (!Arrays.deepEquals(this.produces(), other.produces())) {
            return false;
        }
        String this$virtualHost = this.virtualHost();
        String other$virtualHost = other.virtualHost();
        if (this$virtualHost == null ? other$virtualHost != null : !this$virtualHost.equals(other$virtualHost)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, Object> this$metaData = this.metaData();
        Map<String, Object> other$metaData = other.metaData();
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RouteOptions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.enable() ? 79 : 97);
        result = result * 59 + (this.auth() ? 79 : 97);
        result = result * 59 + (this.noResponseWriter() ? 79 : 97);
        result = result * 59 + (this.methodAsPath() ? 79 : 97);
        result = result * 59 + (this.isBlocking() ? 79 : 97);
        result = result * 59 + (this.blockingOrdered() ? 79 : 97);
        result = result * 59 + (this.disableRequestLog() ? 79 : 97);
        result = result * 59 + (this.disableResponseLog() ? 79 : 97);
        Integer $order = this.order();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        String $path = this.path();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $pathRegex = this.pathRegex();
        result = result * 59 + ($pathRegex == null ? 43 : $pathRegex.hashCode());
        Method $method = this.method();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.consumes());
        result = result * 59 + Arrays.deepHashCode(this.produces());
        String $virtualHost = this.virtualHost();
        result = result * 59 + ($virtualHost == null ? 43 : $virtualHost.hashCode());
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, Object> $metaData = this.metaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RouteOptions(path=" + this.path() + ", pathRegex=" + this.pathRegex() + ", method=" + String.valueOf((Object)this.method()) + ", consumes=" + Arrays.deepToString(this.consumes()) + ", produces=" + Arrays.deepToString(this.produces()) + ", order=" + this.order() + ", enable=" + this.enable() + ", virtualHost=" + this.virtualHost() + ", name=" + this.name() + ", auth=" + this.auth() + ", noResponseWriter=" + this.noResponseWriter() + ", methodAsPath=" + this.methodAsPath() + ", isBlocking=" + this.isBlocking() + ", blockingOrdered=" + this.blockingOrdered() + ", metaData=" + String.valueOf(this.metaData()) + ", disableRequestLog=" + this.disableRequestLog() + ", disableResponseLog=" + this.disableResponseLog() + ")";
    }
}

