/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.http.param.impl;

import io.github.adiitgg.vertx.http.param.ParameterProvider;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import lombok.Generated;

public class CompositeParameterProviderFactory
implements ParameterProvider.Factory {
    private final ParameterProvider.Factory[] factories;

    @Override
    public boolean isSupported(Parameter parameter) {
        for (ParameterProvider.Factory factory : this.factories) {
            if (!factory.isSupported(parameter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParameterProvider create(Parameter parameter) throws Throwable {
        for (ParameterProvider.Factory factory : this.factories) {
            if (!factory.isSupported(parameter)) continue;
            return factory.create(parameter);
        }
        return null;
    }

    @Override
    public ParameterProvider[] provideParameters(Method method) {
        return (ParameterProvider[])Arrays.stream(method.getParameters()).map(parameter -> {
            ParameterProvider.Factory factory = Arrays.stream(this.factories).filter(f -> f.isSupported((Parameter)parameter)).findFirst().orElse(null);
            if (factory == null) {
                throw new IllegalArgumentException("Unsupported parameter type: " + parameter.getType().getSimpleName() + ". No ParameterProvider.Factory found");
            }
            try {
                return factory.create((Parameter)parameter);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Unsupported parameter type: " + parameter.getType().getSimpleName(), e);
            }
        }).toArray(ParameterProvider[]::new);
    }

    @Generated
    public CompositeParameterProviderFactory(ParameterProvider.Factory[] factories) {
        this.factories = factories;
    }
}

