/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.http.param.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.adiitgg.vertx.http.annotation.QueryParam;
import io.github.adiitgg.vertx.http.param.ParameterProvider;
import java.lang.reflect.Parameter;
import lombok.Generated;

public class RequestQueryParamProviderFactory
implements ParameterProvider.Factory {
    private final ObjectMapper objectMapper;

    @Override
    public boolean isSupported(Parameter parameter) {
        return parameter.isAnnotationPresent(QueryParam.class);
    }

    @Override
    public ParameterProvider create(Parameter parameter) throws Throwable {
        QueryParam queryParam = parameter.getAnnotation(QueryParam.class);
        String key = queryParam.value().isBlank() ? parameter.getName() : queryParam.value();
        boolean isString = parameter.getType().isAssignableFrom(String.class);
        return context -> {
            String result = context.request().getParam(key, queryParam.defaultValue());
            if (isString) {
                return result;
            }
            return this.objectMapper.convertValue((Object)result, parameter.getType());
        };
    }

    @Generated
    public RequestQueryParamProviderFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

