/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.http.request.impl;

import io.github.adiitgg.vertx.http.model.ParamType;
import io.github.adiitgg.vertx.http.request.RequestReader;
import io.github.adiitgg.vertx.http.request.RequestValidation;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.Type;
import java.util.List;
import lombok.Generated;

public class CompositeRequestReader
implements RequestReader {
    private final List<RequestReader> requestReaders;
    private final List<RequestValidation> requestValidations;

    @Override
    public boolean isSupported(RoutingContext context, Type type, ParamType paramType) {
        for (RequestReader reader : this.requestReaders) {
            if (!reader.isSupported(context, type, paramType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object read(RoutingContext context, Type type, ParamType paramType) {
        for (RequestReader reader : this.requestReaders) {
            if (!reader.isSupported(context, type, paramType)) continue;
            Object result = reader.read(context, type, paramType);
            if (result != null) {
                for (RequestValidation requestValidation : this.requestValidations) {
                    requestValidation.validate(result);
                }
            }
            return result;
        }
        return null;
    }

    @Generated
    public CompositeRequestReader(List<RequestReader> requestReaders, List<RequestValidation> requestValidations) {
        this.requestReaders = requestReaders;
        this.requestValidations = requestValidations;
    }
}

