/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.http.request.impl.validation;

import io.github.adiitgg.vertx.http.exception.ViolationException;
import io.github.adiitgg.vertx.http.request.RequestValidation;
import jakarta.validation.Configuration;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Collections;
import java.util.Set;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class JakartaValidationRequest
implements RequestValidation {
    private final Validator validator;

    public JakartaValidationRequest() {
        Configuration validationConfiguration = Validation.byDefaultProvider().configure();
        if (this.isParameterMessagInterpolatorExists()) {
            validationConfiguration.messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator());
        }
        ValidatorFactory validatorFactory = validationConfiguration.buildValidatorFactory();
        try {
            this.validator = validatorFactory.getValidator();
        }
        finally {
            if (Collections.singletonList(validatorFactory).get(0) != null) {
                validatorFactory.close();
            }
        }
    }

    private boolean isParameterMessagInterpolatorExists() {
        try {
            Class.forName("org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void validate(Object request) {
        if (request == null) {
            throw new ViolationException("Request body cannot be null");
        }
        Set violations = this.validator.validate(request, new Class[0]);
        if (!violations.isEmpty()) {
            ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
            boolean isDefaultMessage = violation.getMessageTemplate().startsWith("{jakarta.validation.") && violation.getMessageTemplate().endsWith(".message}");
            Object message = violation.getMessage();
            message = isDefaultMessage ? String.valueOf(violation.getPropertyPath()) + " " + (String)message : ((String)message).replace("$field", violation.getPropertyPath().toString());
            throw new ViolationException((String)message);
        }
    }
}

