/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.http.response.impl;

import io.github.adiitgg.vertx.http.model.RouteOptions;
import io.github.adiitgg.vertx.http.response.ResponseMapper;
import io.github.adiitgg.vertx.http.response.ResponseWriter;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.ext.web.RoutingContext;
import lombok.Generated;

public class CompositeResponseWriter
implements ResponseWriter {
    private final ResponseWriter[] responseWriters;
    private final ResponseMapper responseMapper;

    @Override
    public boolean write(RoutingContext context, Buffer result) {
        for (ResponseWriter writer : this.responseWriters) {
            if (!writer.write(context, result)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean write(RoutingContext context, Object result, RouteOptions options) {
        if (result instanceof Buffer) {
            Buffer buffer = (Buffer)result;
            context.put("RES_BODY_BUFF", (Object)buffer);
            return this.write(context, buffer);
        }
        Buffer buffer = this.responseMapper != null ? this.responseMapper.map(context, result) : Json.encodeToBuffer((Object)result);
        context.put("RES_BODY_BUFF", (Object)buffer);
        return this.write(context, buffer);
    }

    @Generated
    public CompositeResponseWriter(ResponseWriter[] responseWriters, ResponseMapper responseMapper) {
        this.responseWriters = responseWriters;
        this.responseMapper = responseMapper;
    }
}

