/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.http.response.impl;

import io.github.adiitgg.vertx.http.response.HttpResponseLogging;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.regex.Pattern;

public final class HttpResponseLoggingImpl
implements HttpResponseLogging {
    private final Logger log = LoggerFactory.getLogger(HttpResponseLogging.class);
    private final Pattern PATTERN_CONTENT_TYPE = Pattern.compile("json|text|url");

    @Override
    public void log(RoutingContext context, Object data) {
        OffsetDateTime startTime = (OffsetDateTime)context.get("START_DTOFFSET", (Object)OffsetDateTime.now());
        HttpServerRequest request = context.request();
        String contentType = request.getHeader(HttpHeaders.CONTENT_TYPE);
        int statusCode = context.response().getStatusCode();
        StringBuilder builder = new StringBuilder("|");
        builder.append(statusCode).append("|");
        if (startTime != null) {
            String took = this.calcTook(startTime);
            builder.append(this.leftPad(took, 8)).append(" | ");
        } else {
            builder.append("| ");
        }
        builder.append(this.leftPad(this.bytesToKilobytes(context.response().bytesWritten()) + "kb", 8)).append(" | ");
        builder.append(this.leftPad(this.getClientIpPort(context.request()), 15)).append(" - ");
        Boolean requestNoLog = (Boolean)context.get("REQ_NO_LOG", (Object)false);
        Boolean responseNoLog = (Boolean)context.get("RES_NO_LOG", (Object)false);
        boolean isReqBodyLoggable = requestNoLog == false && request.method() != HttpMethod.GET && !context.body().isEmpty() && contentType != null && this.PATTERN_CONTENT_TYPE.matcher(contentType).find();
        builder.append(request.method().name()).append(" ").append(request.uri()).append((String)(isReqBodyLoggable ? " - req=" + context.body().asString().replace("\r", "\\r").replace("\n", "\\n") + (responseNoLog != false ? "" : ";") : ""));
        if (!responseNoLog.booleanValue() && data != null) {
            if (!isReqBodyLoggable) {
                builder.append(" - ");
            }
            builder.append("resBody=").append(data);
        }
        this.log.info((Object)builder.toString());
    }

    private String getClientIpPort(HttpServerRequest request) {
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        if (null == xForwardedFor) {
            return request.remoteAddress().toString();
        }
        return xForwardedFor.split(",")[0] + ":" + request.remoteAddress().port();
    }

    private String leftPad(String originalString, int length) {
        char padChar = ' ';
        if (originalString == null) {
            return null;
        }
        int padLength = length - originalString.length();
        if (padLength <= 0) {
            return originalString;
        }
        return String.valueOf(padChar).repeat(padLength) + originalString;
    }

    private String calcTook(OffsetDateTime startTime) {
        Duration duration = Duration.between(startTime, OffsetDateTime.now());
        long minutes = duration.toMinutes();
        long seconds = duration.toMillis() / 1000L;
        long milliseconds = duration.toMillis();
        long nanoseconds = duration.toNanos();
        Object took = "";
        took = minutes > 0L ? minutes + "m" : (seconds > 0L ? seconds + "s" : (milliseconds > 0L ? milliseconds + "ms" : nanoseconds + "ns"));
        return took;
    }

    private String bytesToKilobytes(long bytes) {
        String result = "" + (double)bytes / 1024.0;
        if (result.length() > 6) {
            return result.substring(0, 6);
        }
        return result;
    }
}

