/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.http.util;

import io.github.adiitgg.vertx.http.function.UFunction;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import lombok.Generated;

public final class ReflectionUtil {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();

    public static <T, L> UFunction<T, L> createLambdaFactory(Class<? super L> lambdaType, Method implMethod) {
        Method lambdaMethod = ReflectionUtil.findLambdaMethod(lambdaType);
        MethodType lambdaMethodType = MethodType.methodType(lambdaMethod.getReturnType(), lambdaMethod.getParameterTypes());
        Class<?> implType = implMethod.getDeclaringClass();
        MethodType implMethodType = MethodType.methodType(implMethod.getReturnType(), implMethod.getParameterTypes());
        MethodHandle implMethodHandle = lookup.findVirtual(implType, implMethod.getName(), implMethodType);
        MethodType invokedMethodType = MethodType.methodType(lambdaType, implType);
        CallSite metafactory = LambdaMetafactory.metafactory(lookup, lambdaMethod.getName(), invokedMethodType, lambdaMethodType, implMethodHandle, implMethodType);
        MethodHandle factory = metafactory.getTarget();
        return instance -> {
            Object lambda = factory.invoke(instance);
            return lambda;
        };
    }

    public static Method findLambdaMethod(Class<?> type) {
        if (!type.isInterface()) {
            throw new IllegalArgumentException("This must be interface: " + String.valueOf(type));
        }
        Method[] methods = ReflectionUtil.getAllMethods(type);
        if (methods.length == 0) {
            throw new IllegalArgumentException("No methods in: " + type.getName());
        }
        Method targetMethod = null;
        for (Method method : methods) {
            if (!ReflectionUtil.isInterfaceMethod(method)) continue;
            if (targetMethod != null) {
                throw new IllegalArgumentException("This isn't functional interface: " + type.getName());
            }
            targetMethod = method;
        }
        if (targetMethod == null) {
            throw new IllegalArgumentException("No method in: " + type.getName());
        }
        return targetMethod;
    }

    public static boolean isInterfaceMethod(Method method) {
        return !method.isDefault() && Modifier.isAbstract(method.getModifiers());
    }

    public static Method[] getAllMethods(Class<?> type) {
        LinkedList<Method> result = new LinkedList<Method>();
        Class<?> current = type;
        do {
            result.addAll(0, Arrays.asList(current.getDeclaredMethods()));
        } while ((current = current.getSuperclass()) != null);
        return result.toArray(new Method[0]);
    }

    public static <T extends Annotation> T getAnnotation(int modifiers, Annotation[] annotations, Class<T> annotation) {
        if (Modifier.isStatic(modifiers)) {
            return null;
        }
        if (!Modifier.isPublic(modifiers)) {
            return null;
        }
        for (Annotation ann : annotations) {
            if (!ann.annotationType().equals(annotation)) continue;
            return (T)ann;
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotation) {
        return ReflectionUtil.getAnnotation(clazz.getModifiers(), clazz.getAnnotations(), annotation);
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotation) {
        return ReflectionUtil.getAnnotation(method.getModifiers(), method.getAnnotations(), annotation);
    }

    @Generated
    private ReflectionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

