/*
 * Decompiled with CFR 0.152.
 */
package io.github.adiitgg.vertx.http.util;

import io.github.adiitgg.vertx.http.impl.RouterBuilderImpl;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.impl.RouteImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public final class RouterUtil {
    public static String getRouteList(List<Route> routerRoutes) {
        StringBuilder sb = new StringBuilder("\r\n");
        sb.append(String.format("%-5s ", "ORDER")).append(String.format("%9s ", "STATUS")).append(String.format("%10s ", "METHODS")).append(String.format("%-25s ", "ROUTE")).append("Handlers").append("\r\n");
        Field stateField = RouteImpl.class.getDeclaredField("state");
        stateField.setAccessible(true);
        Method isEnabledMethod = null;
        Method contextHandlersMethod = null;
        Method orderMethod = null;
        for (Route route : routerRoutes) {
            RouteImpl routeImpl = (RouteImpl)route;
            String path = routeImpl.getPath();
            String apiPath = path == null ? "" : path;
            Object routeState = stateField.get(routeImpl);
            if (contextHandlersMethod == null) {
                contextHandlersMethod = routeState.getClass().getDeclaredMethod("getContextHandlers", new Class[0]);
                contextHandlersMethod.setAccessible(true);
            }
            if (isEnabledMethod == null) {
                isEnabledMethod = routeState.getClass().getDeclaredMethod("isEnabled", new Class[0]);
                isEnabledMethod.setAccessible(true);
            }
            if (orderMethod == null) {
                orderMethod = routeState.getClass().getDeclaredMethod("getOrder", new Class[0]);
                orderMethod.setAccessible(true);
            }
            int order = (Integer)orderMethod.invoke(routeState, new Object[0]);
            Boolean enable = (Boolean)isEnabledMethod.invoke(routeState, new Object[0]);
            Set methods = routeImpl.methods();
            List<String> handlers = Objects.requireNonNullElse((List)contextHandlersMethod.invoke(routeState, new Object[0]), Collections.emptyList()).stream().map(h -> {
                if (h.getClass().getName().startsWith(RouterBuilderImpl.class.getName())) {
                    return (String)route.getMetadata("classMethodHandler");
                }
                return h.getClass().getName();
            }).toList();
            sb.append(String.format("%5s ", order)).append(String.format("%9s ", enable != false ? "ACTIVE" : "INACTIVE")).append(String.format("%10s ", methods)).append(String.format("%-25s ", apiPath)).append(String.join((CharSequence)",", handlers)).append("\r\n");
        }
        return sb.toString();
    }

    @Generated
    private RouterUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

