/*
 * Decompiled with CFR 0.152.
 */
package io.github.adityasingh9699.cache;

import io.github.adityasingh9699.cache.CacheEntry;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class FlexibleCache<T> {
    private final Map<String, CacheEntry<T>> cache = new ConcurrentHashMap<String, CacheEntry<T>>();
    private final ScheduledExecutorService cleaner = Executors.newSingleThreadScheduledExecutor();
    private final int maxSize;

    public FlexibleCache(long ttl, TimeUnit unit, int maxSize) {
        this.maxSize = maxSize;
        long ttlMillisecond = unit.toMillis(ttl);
        this.cleaner.scheduleAtFixedRate(() -> this.evictExpiredEntries(ttlMillisecond), ttlMillisecond, ttlMillisecond, TimeUnit.MILLISECONDS);
    }

    public void put(String key, T value) {
        if (this.cache.size() >= this.maxSize) {
            this.evictOldest();
        }
        this.cache.put(key, new CacheEntry<T>(value, System.currentTimeMillis()));
    }

    public Optional<T> get(String key) {
        CacheEntry<T> entry = this.cache.get(key);
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(entry.value());
    }

    public void remove(String key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public int size() {
        return this.cache.size();
    }

    private void evictExpiredEntries(long ttlMillis) {
        long now = System.currentTimeMillis();
        this.cache.entrySet().removeIf(entry -> now - ((CacheEntry)entry.getValue()).timestamp() > ttlMillis);
    }

    private void evictOldest() {
        if (this.cache.isEmpty()) {
            return;
        }
        String oldestKey = (String)Collections.min(this.cache.entrySet(), Comparator.comparingLong(e -> ((CacheEntry)e.getValue()).timestamp())).getKey();
        this.cache.remove(oldestKey);
    }
}

