/*
 * Decompiled with CFR 0.152.
 */
package io.github.admin4j.http;

import com.alibaba.fastjson.JSON;
import io.github.admin4j.http.core.AbstractHttpRequest;
import io.github.admin4j.http.core.HttpConfig;
import io.github.admin4j.http.core.MediaTypeEnum;
import io.github.admin4j.http.core.Method;
import io.github.admin4j.http.core.Pair;
import io.github.admin4j.http.factory.HttpClientFactory;
import java.io.InputStream;
import java.util.Map;
import okhttp3.Callback;
import okhttp3.Response;

public class ApiClient
extends AbstractHttpRequest {
    public ApiClient() {
    }

    public ApiClient(HttpConfig httpConfig) {
        this.okHttpClient = HttpClientFactory.okHttpClient(httpConfig);
        this.followRedirects = httpConfig.isFollowRedirects();
        this.headerMap.put("User-Agent", httpConfig.getUserAgent());
        this.headerMap.put("Referer", httpConfig.getReferer());
    }

    @Override
    public String serializeJSON(Object obj) {
        return JSON.toJSONString((Object)obj);
    }

    public Response get(String path, Map<String, Object> queryMap) {
        return this.get(path, queryMap, null);
    }

    public Response get(String path, Pair<?> ... queryParams) {
        return this.get(path, (Map<String, Object>)null, queryParams);
    }

    public Response postForm(String url, Map<String, Object> formParams) {
        return this.post(url, MediaTypeEnum.FORM, null, formParams, null);
    }

    public void asyncPostForm(String url, Map<String, Object> formParams, Callback callback) {
        this.asyncPost(url, MediaTypeEnum.FORM, null, formParams, null, callback);
    }

    public Response postFormData(String url, Map<String, Object> formParams) {
        return this.post(url, MediaTypeEnum.FORM_DATA, null, formParams, null);
    }

    public void asyncPostFormData(String url, Map<String, Object> formParams, Callback callback) {
        this.asyncPost(url, MediaTypeEnum.FORM_DATA, null, formParams, null, callback);
    }

    public Response post(String url, Object body) {
        return this.post(url, MediaTypeEnum.JSON, body, null, null);
    }

    public void asyncPost(String url, Object body, Callback callback) {
        this.asyncPost(url, MediaTypeEnum.JSON, body, null, null, callback);
    }

    public InputStream down(String url) {
        return this.executeByteStream(url, Method.GET, null, null, null, null, null, null);
    }
}

