/*
 * Decompiled with CFR 0.152.
 */
package io.github.admin4j.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import io.github.admin4j.http.core.AbstractHttpRequest;
import io.github.admin4j.http.core.HttpCallback;
import io.github.admin4j.http.core.HttpConfig;
import io.github.admin4j.http.core.MediaTypeEnum;
import io.github.admin4j.http.core.Pair;
import io.github.admin4j.http.exception.HttpException;
import io.github.admin4j.http.factory.HttpClientFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class ApiJsonClient
extends AbstractHttpRequest {
    public ApiJsonClient() {
    }

    public ApiJsonClient(HttpConfig config) {
        this.okHttpClient = HttpClientFactory.okHttpClient(config);
        this.headerMap.put("User-Agent", config.getUserAgent());
        this.headerMap.put("Referer", config.getReferer());
        this.followRedirects = config.isFollowRedirects();
    }

    @Override
    public String serializeJSON(Object obj) {
        return JSON.toJSONString((Object)obj);
    }

    public <T> T deserializeJSON(InputStream in, Class<T> tClass) throws IOException {
        return (T)JSON.parseObject((InputStream)in, (Charset)this.charset, tClass, (Feature[])new Feature[0]);
    }

    public <T> T execute(Call call, Class<T> tClass) throws HttpException {
        try {
            Response response = call.execute();
            return this.handleResponse(response, tClass);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    public <T> void executeAsync(Call call, final Class<T> tClass, final HttpCallback<T> callback) {
        call.enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Object result;
                try {
                    result = ApiJsonClient.this.handleResponse(response, tClass);
                }
                catch (Exception e) {
                    callback.onFailure(e, response.code(), response.headers().toMultimap());
                    return;
                }
                callback.onSuccess(result, response.code(), response.headers().toMultimap());
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                callback.onFailure(e, 0, null);
            }
        });
    }

    protected <T> T handleResponse(Response response, Class<T> tClass) throws HttpException {
        if ((response = this.handleResponse(response)).isSuccessful()) {
            try {
                if (tClass == null) {
                    if (response.body() != null || response.code() == 204) {
                        response.body().close();
                    }
                    return null;
                }
                return this.handleSuccessResponse(response, tClass);
            }
            catch (IOException e) {
                throw new HttpException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
            }
        }
        T o = this.handleFailResponse(response, tClass);
        if (o != null) {
            return o;
        }
        String respBody = null;
        if (response.body() != null) {
            try {
                respBody = response.body().string();
            }
            catch (IOException e) {
                throw new HttpException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
            }
        }
        throw new HttpException(response.message(), response.code(), response.headers().toMultimap(), respBody);
    }

    protected <T> T handleSuccessResponse(Response response, Class<T> tClass) throws IOException {
        return this.deserializeJSON(response.body().byteStream(), tClass);
    }

    protected <T> T handleFailResponse(Response response, Class<T> tClass) {
        return null;
    }

    protected JSONObject serialize(Response response) {
        ResponseBody body = response.body();
        if (body == null) {
            throw new HttpException("response body is null");
        }
        try {
            return JSONObject.parseObject((String)body.string());
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    protected JSONArray serializeList(Response response) {
        ResponseBody body = response.body();
        if (body == null) {
            throw new HttpException("response body is null");
        }
        try {
            return JSON.parseArray((String)body.string());
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    public <T> T get(String path, Class<T> tClass, Pair<?> ... queryParams) {
        Call call = this.buildGet(path, null, queryParams);
        return this.execute(call, tClass);
    }

    public <T> T get(String path, Map<String, Object> queryMap, Class<T> tClass) {
        Call call = this.buildGet(path, queryMap, new Pair[]{null});
        return this.execute(call, tClass);
    }

    public <T> T postForm(String url, Map<String, Object> formParams, Class<T> tClass) {
        Response response = this.post(url, MediaTypeEnum.FORM, null, formParams, null);
        return this.handleResponse(response, tClass);
    }

    public <T> T postFormData(String url, Map<String, Object> formParams, Class<T> tClass) {
        Response response = this.post(url, MediaTypeEnum.FORM_DATA, null, formParams, null);
        return this.handleResponse(response, tClass);
    }

    public <T> T post(String url, Object body, Class<T> tClass) {
        Response response = this.post(url, MediaTypeEnum.JSON, body, null, null);
        return this.handleResponse(response, tClass);
    }

    public JSONObject get(String path, Pair<?> ... queryParams) {
        Response response = this.get(path, (Map<String, Object>)null, queryParams);
        return this.handleResponse(response, JSONObject.class);
    }

    public JSONObject get(String path, Map<String, Object> queryMap) {
        Response response = this.get(path, queryMap, (Pair[])null);
        return this.handleResponse(response, JSONObject.class);
    }

    public JSONArray getList(String path, Pair<?> ... queryParams) {
        Response response = this.get(path, (Map<String, Object>)null, queryParams);
        return this.handleResponse(response, JSONArray.class);
    }

    public JSONArray getList(String path, Map<String, Object> queryMap) {
        Response response = this.get(path, queryMap, (Pair[])null);
        return this.handleResponse(response, JSONArray.class);
    }

    public JSONObject postForm(String url, Map<String, Object> formParams) {
        Response response = this.post(url, MediaTypeEnum.FORM, null, formParams, null);
        return this.handleResponse(response, JSONObject.class);
    }

    public JSONObject postFormData(String url, Map<String, Object> formParams) {
        Response response = this.post(url, MediaTypeEnum.FORM_DATA, null, formParams, null);
        return this.handleResponse(response, JSONObject.class);
    }

    public JSONObject post(String url, Object body) {
        Response response = this.post(url, MediaTypeEnum.JSON, body, null, null);
        return this.handleResponse(response, JSONObject.class);
    }
}

