/*
 * Decompiled with CFR 0.152.
 */
package io.github.admin4j.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import io.github.admin4j.http.ApiClient;
import io.github.admin4j.http.core.MediaTypeEnum;
import io.github.admin4j.http.core.Method;
import io.github.admin4j.http.core.Pair;
import io.github.admin4j.http.util.HttpUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class HttpRequest {
    private Method method;
    private MediaTypeEnum mediaType;
    private Map<String, Object> queryMap;
    private Pair<?>[] queryParams;
    private String url;
    private Map<String, Object> form;
    private Map<String, Object> headers;
    private Object body;

    public static HttpRequest post(String url) {
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.url = url;
        httpRequest.method = Method.POST;
        return httpRequest;
    }

    public static HttpRequest get(String url) {
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.url = url;
        httpRequest.method = Method.GET;
        return httpRequest;
    }

    public HttpRequest userAgent(String userAgent) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>(8);
        }
        this.headers.put("User-Agent", userAgent);
        return this;
    }

    public HttpRequest referer(String referer) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>(8);
        }
        this.headers.put("Referer", referer);
        return this;
    }

    public HttpRequest header(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>(8);
        }
        this.headers.put(key, value);
        return this;
    }

    public HttpRequest headers(Map<String, Object> headers) {
        if (headers == null) {
            headers = new HashMap<String, Object>(8);
        }
        this.headers = headers;
        return this;
    }

    public HttpRequest queryMap(String key, String value) {
        if (this.queryMap == null) {
            this.queryMap = new HashMap<String, Object>(8);
        }
        this.queryMap.put(key, value);
        return this;
    }

    public HttpRequest queryParams(Pair<?> ... queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public HttpRequest form(String key, Object value) {
        this.mediaType = MediaTypeEnum.FORM;
        if (this.form == null) {
            this.form = new HashMap<String, Object>(8);
        }
        this.form.put(key, value);
        return this;
    }

    public HttpRequest body(Object body) {
        this.mediaType = MediaTypeEnum.JSON;
        this.body = body;
        return this;
    }

    public Response execute() {
        ApiClient apiClient = HttpUtil.getClient();
        Call call = apiClient.buildCall(this.url, this.method, this.mediaType, this.queryParams, this.queryMap, this.body, this.form, this.headers);
        return apiClient.execute(call);
    }

    public void asyncExecute(Callback callback) {
        ApiClient apiClient = HttpUtil.getClient();
        Call call = apiClient.buildCall(this.url, this.method, this.mediaType, this.queryParams, this.queryMap, this.body, this.form, this.headers);
        apiClient.executeAsync(call, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Class<T> clas) throws IOException {
        InputStream is = Objects.requireNonNull(this.execute().body()).byteStream();
        try {
            Object object = JSON.parseObject((InputStream)is, clas, (Feature[])new Feature[0]);
            return (T)object;
        }
        finally {
            if (Collections.singletonList(is).get(0) != null) {
                is.close();
            }
        }
    }

    public void setForm(Map<String, Object> form) {
        this.form = form;
    }

    public void setBody(Object body) {
        this.body = body;
    }
}

