/*
 * Decompiled with CFR 0.152.
 */
package io.github.admin4j.http.core;

import io.github.admin4j.http.core.MediaTypeEnum;
import io.github.admin4j.http.core.Method;
import io.github.admin4j.http.core.Pair;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpBuildCall {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpBuildCall.class);
    protected Map<String, String> headerMap = new HashMap<String, String>();
    protected String baseUrl = null;
    protected Charset charset = StandardCharsets.UTF_8;

    public abstract OkHttpClient getHttpClient();

    protected MediaType getMediaType() {
        if (this.headerMap.containsKey("Content-Type")) {
            return MediaType.parse((String)this.headerMap.get("Content-Type"));
        }
        return null;
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replace("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public String buildUrl(String path, Pair<?>[] queryParams, Map<String, Object> queryMap) {
        String prefix;
        if (StringUtils.isBlank((CharSequence)this.baseUrl) && queryParams == null && queryMap == null) {
            return path;
        }
        StringBuilder url = new StringBuilder();
        if (StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)"http")) {
            url.append(path);
        } else {
            url.append(this.baseUrl).append(path);
        }
        if (queryParams != null && queryParams.length > 0) {
            prefix = path.contains("?") ? "&" : "?";
            for (Pair<?> param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                String value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
            }
        }
        if (queryMap != null && !queryMap.isEmpty()) {
            prefix = url.toString().contains("?") ? "&" : "?";
            for (Map.Entry entry : queryMap.entrySet()) {
                if (entry.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                String value = this.parameterToString(entry.getValue());
                url.append(this.escapeString((String)entry.getKey())).append("=").append(this.escapeString(value));
            }
        }
        return url.toString();
    }

    public String buildUrl(String path, Pair<?>[] queryParams) {
        return this.buildUrl(path, queryParams, null);
    }

    public String buildUrl(String path, Map<String, Object> queryMap) {
        return this.buildUrl(path, null, queryMap);
    }

    protected void processHeaderParams(Map<String, Object> headerParams, Request.Builder reqBuilder) {
        for (Map.Entry<String, String> header : this.headerMap.entrySet()) {
            if (headerParams != null && headerParams.containsKey(header.getKey())) continue;
            reqBuilder.header(header.getKey(), this.parameterToString(header.getValue()));
        }
        if (ObjectUtils.isEmpty(headerParams)) {
            return;
        }
        for (Map.Entry<String, Object> param : headerParams.entrySet()) {
            reqBuilder.header(param.getKey(), this.parameterToString(param.getValue()));
        }
    }

    protected Request buildRequest(String url, Method method, MediaTypeEnum mediaType, Object body, Map<String, Object> formParams, Map<String, Object> headerParams) {
        Object reqBody;
        if (!StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)"http")) {
            url = this.buildUrl(url, null, null);
        }
        Request.Builder reqBuilder = new Request.Builder().url(url);
        this.processHeaderParams(headerParams, reqBuilder);
        if (!HttpMethod.permitsRequestBody((String)method.name())) {
            return reqBuilder.method(method.name(), null).build();
        }
        if (mediaType == null) {
            Object contentType = ObjectUtils.isEmpty(headerParams) ? null : headerParams.get("Content-Type");
            MediaTypeEnum mediaTypeEnum = mediaType = contentType == null ? MediaTypeEnum.JSON : MediaTypeEnum.of(contentType);
        }
        if (MediaTypeEnum.FORM.equals((Object)mediaType)) {
            reqBody = this.buildRequestBodyFormEncoding(formParams);
        } else if (MediaTypeEnum.FORM_DATA.equals((Object)mediaType)) {
            reqBody = this.buildRequestBodyMultipart(formParams);
        } else {
            MediaType media = this.getMediaType();
            MediaType mediaType2 = media = media == null ? mediaType.getMediaType() : media;
            reqBody = body == null ? (Method.DELETE.equals((Object)method) ? null : RequestBody.create((MediaType)media, (String)"")) : this.serialize(body, media);
        }
        return reqBuilder.method(method.name(), reqBody).build();
    }

    protected RequestBody serialize(Object obj, MediaType mediaType) {
        if (obj instanceof byte[]) {
            return RequestBody.create((MediaType)mediaType, (byte[])((byte[])obj));
        }
        if (obj instanceof File) {
            return RequestBody.create((MediaType)mediaType, (File)((File)obj));
        }
        if (obj instanceof String) {
            return RequestBody.create((MediaType)mediaType, (String)((String)obj));
        }
        String content = obj != null ? this.serializeJSON(obj) : "";
        byte[] bytes = content.getBytes(this.charset);
        return RequestBody.create((MediaType)mediaType, (byte[])bytes);
    }

    public abstract String serializeJSON(Object var1);

    protected String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date || param instanceof OffsetDateTime || param instanceof LocalDate) {
            String jsonStr = this.serializeJSON(param);
            return jsonStr.substring(1, jsonStr.length() - 1);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(o);
            }
            return b.toString();
        }
        if (param instanceof String) {
            return (String)param;
        }
        return String.valueOf(param);
    }

    protected RequestBody buildRequestBodyFormEncoding(Map<String, Object> formParams) {
        if (formParams == null || formParams.isEmpty()) {
            FormBody.Builder builder = new FormBody.Builder();
            return builder.build();
        }
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            builder.add(param.getKey(), this.parameterToString(param.getValue()));
        }
        return builder.build();
    }

    protected RequestBody buildRequestBodyMultipart(Map<String, Object> formParams) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaTypeEnum.FORM_DATA.getMediaType());
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            if (param.getValue() instanceof File) {
                File file = (File)param.getValue();
                Headers partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\"; filename=\"" + file.getName() + "\""});
                MediaType mediaType = this.guessContentTypeFromFile(file);
                builder.addPart(partHeaders, RequestBody.create((MediaType)mediaType, (File)file));
                continue;
            }
            Headers partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\""});
            builder.addPart(partHeaders, RequestBody.create(null, (String)this.parameterToString(param.getValue())));
        }
        return builder.build();
    }

    protected MediaType guessContentTypeFromFile(File file) {
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        if (contentType == null) {
            return MediaTypeEnum.OCTET_STREAM.getMediaType();
        }
        return MediaType.parse((String)contentType);
    }

    public Call buildCall(String path, Method method, MediaTypeEnum mediaType, Pair<?>[] queryParams, Map<String, Object> queryMap, Object body, Map<String, Object> formParams, Map<String, Object> headerParams) {
        String url = this.buildUrl(path, queryParams, queryMap);
        Request request = this.buildRequest(url, method, mediaType, body, formParams, headerParams);
        return this.getHttpClient().newCall(request);
    }

    public Call buildCall(String url, Method method, Object body, Map<String, Object> formParams, Map<String, Object> headerParams) {
        return this.buildCall(url, method, null, null, null, body, formParams, headerParams);
    }

    protected Request buildRedirectRequest(Response response) {
        String location = response.header("Location");
        if (StringUtils.isBlank((CharSequence)location)) {
            return null;
        }
        Request request = response.request();
        HttpUrl url = request.url().resolve(location);
        Request.Builder builder = request.newBuilder();
        return builder.url(url).build();
    }

    public Call buildGet(String path, Map<String, Object> queryMap, Pair<?> ... queryParams) {
        return this.buildCall(path, Method.GET, null, queryParams, queryMap, null, null, null);
    }

    protected Call buildPost(String url, MediaTypeEnum mediaTypeEnum, Object body, Map<String, Object> formParams, Map<String, Object> headerParams) {
        Request request = this.buildRequest(url, Method.POST, mediaTypeEnum, body, formParams, headerParams);
        return this.getHttpClient().newCall(request);
    }
}

