/*
 * Decompiled with CFR 0.152.
 */
package io.github.admin4j.http.core;

import io.github.admin4j.http.core.AbstractHttpBuildCall;
import io.github.admin4j.http.core.MediaTypeEnum;
import io.github.admin4j.http.core.Method;
import io.github.admin4j.http.core.Pair;
import io.github.admin4j.http.exception.HttpException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.UnaryOperator;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpExecute
extends AbstractHttpBuildCall {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpExecute.class);
    protected boolean followRedirects = true;

    public Response execute(Call call) throws HttpException {
        return this.execute(call, this::handleResponse);
    }

    public Response execute(Call call, UnaryOperator<Response> function) throws HttpException {
        try {
            Response response = call.execute();
            response = (Response)function.apply(response);
            return response;
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    public void executeAsync(Call call, Callback callback) {
        call.enqueue(callback);
    }

    protected InputStream executeByteStream(String path, Method method, MediaTypeEnum mediaType, Pair<?>[] queryParams, Map<String, Object> queryMap, Object body, Map<String, Object> formParams, Map<String, Object> headerParams) {
        Response response = null;
        try {
            Call call = this.buildCall(path, method, mediaType, queryParams, queryMap, body, formParams, headerParams);
            response = this.execute(call);
            ResponseBody responseBody = response.body();
            if (!response.isSuccessful()) {
                log.error("executeByteStream ERROR" + responseBody.string());
                throw new HttpException(response);
            }
            return responseBody != null ? responseBody.byteStream() : null;
        }
        catch (IOException var8) {
            log.error("executeByteStream Exception", (Throwable)var8);
            throw new HttpException(var8.getMessage());
        }
    }

    protected Response handleResponse(Response response) {
        if (response.isSuccessful()) {
            return response;
        }
        if (this.followRedirects && response.code() <= 399 && response.code() >= 300) {
            Request request = this.buildRedirectRequest(response);
            if (request == null) {
                throw new HttpException("not find Redirect url");
            }
            Call call = this.getHttpClient().newCall(request);
            return this.execute(call);
        }
        return response;
    }
}

