/*
 * Decompiled with CFR 0.152.
 */
package io.github.admin4j.http.core;

import io.github.admin4j.http.core.AbstractHttpExecute;
import io.github.admin4j.http.core.HttpConfig;
import io.github.admin4j.http.core.HttpDefaultConfig;
import io.github.admin4j.http.core.MediaTypeEnum;
import io.github.admin4j.http.core.Pair;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpRequest
extends AbstractHttpExecute {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpRequest.class);
    protected OkHttpClient okHttpClient;

    public AbstractHttpRequest() {
        HttpConfig httpConfig = HttpDefaultConfig.get();
        this.headerMap.put("User-Agent", httpConfig.getUserAgent());
        this.headerMap.put("Referer", httpConfig.getReferer());
        this.init();
    }

    protected void init() {
    }

    @Override
    public OkHttpClient getHttpClient() {
        return this.okHttpClient == null ? HttpDefaultConfig.getClient() : this.okHttpClient;
    }

    public Response get(String path, Map<String, Object> queryMap, Pair<?> ... queryParams) {
        Call call = this.buildGet(path, queryMap, queryParams);
        return this.execute(call);
    }

    public Response post(String url, MediaTypeEnum mediaTypeEnum, Object body, Map<String, Object> formParams, Map<String, Object> headerParams) {
        Call call = this.buildPost(url, mediaTypeEnum, body, formParams, headerParams);
        return this.execute(call);
    }

    public void asyncPost(String url, MediaTypeEnum mediaTypeEnum, Object body, Map<String, Object> formParams, Map<String, Object> headerParams, Callback callback) {
        Call call = this.buildPost(url, mediaTypeEnum, body, formParams, headerParams);
        this.executeAsync(call, callback);
    }
}

