/*
 * Decompiled with CFR 0.152.
 */
package io.github.admin4j.http.core;

import okhttp3.MediaType;
import org.apache.commons.lang3.StringUtils;

public enum MediaTypeEnum {
    JSON(MediaType.parse((String)"application/json;charset=utf-8")),
    FORM(MediaType.parse((String)"application/x-www-form-urlencoded;charset=UTF-8")),
    FORM_DATA(MediaType.parse((String)"multipart/form-data")),
    XML(MediaType.parse((String)"text/xml;charset=UTF-8")),
    PLAIN(MediaType.parse((String)"text/plain;charset=UTF-8")),
    HTML(MediaType.parse((String)"text/html;charset=UTF-8")),
    OCTET_STREAM(MediaType.parse((String)"application/octet-stream")),
    OTHER(null);

    private final MediaType mediaType;

    private MediaTypeEnum(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public static MediaTypeEnum of(Object contentType) {
        if (contentType instanceof MediaTypeEnum) {
            return (MediaTypeEnum)((Object)contentType);
        }
        if (contentType instanceof String) {
            String contentStr = (String)contentType;
            contentType = StringUtils.substringBefore((String)contentStr, (String)";");
            String type = StringUtils.substringBefore((String)contentStr, (String)"/");
            String subType = StringUtils.substringAfter((String)contentStr, (String)"/");
            for (MediaTypeEnum mediaType : MediaTypeEnum.values()) {
                if (!mediaType.getMediaType().type().equals(type) || !mediaType.getMediaType().subtype().equals(subType)) continue;
                return mediaType;
            }
        }
        return OTHER;
    }

    public String toString() {
        return this.mediaType.toString();
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }
}

