/*
 * Decompiled with CFR 0.152.
 */
package io.github.admin4j.http.factory;

import io.github.admin4j.http.core.HttpConfig;
import io.github.admin4j.http.core.HttpLogger;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.CookieJar;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;

public class HttpClientFactory {
    public static OkHttpClient okHttpClient(HttpConfig httpConfig) {
        ConnectionPool connectionPool = new ConnectionPool(httpConfig.getMaxIdleConnections(), httpConfig.getKeepAliveDuration(), TimeUnit.SECONDS);
        HttpLoggingInterceptor logInterceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)new HttpLogger());
        logInterceptor.setLevel(httpConfig.getLoggLevel());
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectionPool(connectionPool).followRedirects(false).addNetworkInterceptor((Interceptor)logInterceptor).readTimeout(Duration.ofSeconds(httpConfig.getReadTimeout())).connectTimeout(Duration.ofSeconds(httpConfig.getReadTimeout()));
        if (httpConfig.isCookie()) {
            CookieManager cookieManager = new CookieManager(null, CookiePolicy.ACCEPT_ORIGINAL_SERVER);
            builder.cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager));
        }
        if (httpConfig.getProxy() != null) {
            builder.proxy(new Proxy(httpConfig.getProxy().getType(), new InetSocketAddress(httpConfig.getProxy().getHost(), (int)httpConfig.getProxy().getPort())));
            if (StringUtils.isNotBlank((CharSequence)httpConfig.getProxy().getPassword())) {
                builder.proxyAuthenticator((route, response) -> {
                    String credential = Credentials.basic((String)httpConfig.getProxy().getUserName(), (String)httpConfig.getProxy().getPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                });
            }
        }
        return builder.build();
    }
}

